/*
 * Decompiled with CFR 0.152.
 */
package me.blueyescat.skriptholo.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.registrations.Converters;
import ch.njol.skript.util.Utils;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import com.gmail.filoghost.holographicdisplays.api.line.HologramLine;
import com.gmail.filoghost.holographicdisplays.api.line.ItemLine;
import com.gmail.filoghost.holographicdisplays.api.line.TextLine;
import java.lang.reflect.Array;
import java.util.ArrayList;
import me.blueyescat.skriptholo.skript.Types;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Hologram Line Content")
@Description(value={"Returns content (text or item) of a hologram line. Please note that there are hologram line to text and item converters so you can use a hologram line like a text or an item (e.g. give first line of holo to player)"})
@Examples(value={"give items in lines of last created hologram to player", "message text of line 3 of {_holo}", "set {_contents::*} to contents of all lines of {_holo0"})
@Since(value="1.0.0")
public class ExprHologramLineContent<T>
extends SimpleExpression<T> {
    private final ExprHologramLineContent<?> source;
    private final Class<T> superType;
    private Expression<HologramLine> lines;
    private int type;

    public ExprHologramLineContent() {
        this(null, Object.class);
    }

    private ExprHologramLineContent(ExprHologramLineContent<?> source, Class<? extends T> ... types) {
        this.source = source;
        if (source != null) {
            this.lines = source.lines;
            this.type = source.type;
        }
        this.superType = Utils.getSuperType((Class[])types);
    }

    public Expression<?> getSource() {
        return this.source == null ? this : this.source;
    }

    public final <R> Expression<? extends R> getConvertedExpression(Class<R> ... to) {
        return new ExprHologramLineContent<R>(this, to);
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.lines = exprs[0];
        this.type = parseResult.mark;
        return true;
    }

    protected T[] get(Event e) {
        ArrayList<String> contents = new ArrayList<String>();
        for (HologramLine line : (HologramLine[])this.lines.getArray(e)) {
            if (line instanceof TextLine) {
                if (this.type != 0 && this.type != 1) continue;
                contents.add(((TextLine)line).getText());
                continue;
            }
            if (!(line instanceof ItemLine) || this.type != 0 && this.type != 2) continue;
            contents.add((String)new ItemType(((ItemLine)line).getItemStack()));
        }
        try {
            return Converters.convertStrictly((Object[])contents.toArray(), this.superType);
        }
        catch (ClassCastException cce) {
            return (Object[])Array.newInstance(this.superType, 0);
        }
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.DELETE || mode == Changer.ChangeMode.RESET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{String.class, ItemType.class});
        }
        return null;
    }

    public void change(Event e, @Nullable Object[] delta, Changer.ChangeMode mode) {
        Types.hologramLineChanger.change(this.lines.getArray(e), delta, mode);
    }

    public boolean isSingle() {
        return this.lines.isSingle();
    }

    public Class<? extends T> getReturnType() {
        return this.superType;
    }

    public String toString(@Nullable Event e, boolean debug) {
        if (this.type == 1) {
            return "the text of " + this.lines.toString(e, debug);
        }
        if (this.type == 2) {
            return "the item of " + this.lines.toString(e, debug);
        }
        return "the content of " + this.lines.toString(e, debug);
    }

    static {
        Skript.registerExpression(ExprHologramLineContent.class, Object.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"[the] (content|1\u00a6(text|string)|2\u00a6item)[s] (of|in) [holo[gram] line[s]] %hologramlines%", "%hologramlines%'[s] (content|1\u00a6(text|string)|2\u00a6item)[s]"});
    }
}

