/*
 * Decompiled with CFR 0.152.
 */
package me.blueyescat.skriptholo.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.Direction;
import ch.njol.util.Kleenean;
import com.gmail.filoghost.holographicdisplays.api.Hologram;
import org.bukkit.Location;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Teleport Hologram")
@Description(value={"Teleports a hologram to a specific location."})
@Examples(value={"teleport event-holo to the player", "teleport holograms {_holograms:*} to {_location}"})
@Since(value="1.0.0")
public class EffTeleportHologram
extends Effect {
    private Expression<Hologram> holograms;
    private Expression<Location> location;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.holograms = exprs[0];
        this.location = Direction.combine(exprs[1], exprs[2]);
        return true;
    }

    protected void execute(Event e) {
        Location location = (Location)this.location.getSingle(e);
        if (location == null) {
            return;
        }
        for (Hologram holo : (Hologram[])this.holograms.getArray(e)) {
            holo.teleport(location);
        }
    }

    public String toString(@Nullable Event e, boolean debug) {
        return "teleport " + this.holograms.toString(e, debug) + " to " + this.location.toString(e, debug);
    }

    static {
        Skript.registerEffect(EffTeleportHologram.class, (String[])new String[]{"teleport [holo[gram][s]] %holograms% (to|%direction%) %location%"});
    }
}

