/*
 * Decompiled with CFR 0.152.
 */
package me.blueyescat.skriptholo;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptAddon;
import com.gmail.filoghost.holographicdisplays.api.Hologram;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import me.blueyescat.skriptholo.util.Metrics;
import me.blueyescat.skriptholo.util.Utils;
import org.bukkit.entity.Entity;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.util.Vector;

public class SkriptHolo
extends JavaPlugin
implements Listener {
    private static SkriptHolo instance;
    private static SkriptAddon addonInstance;
    public static boolean startedFollowingHologramTasks;
    public static Map<Integer, Map<Hologram, Vector>> followingHolograms;
    public static Map<Entity, List<Hologram>> followingHologramsEntities;
    public static Set<Hologram> followingHologramsList;

    public SkriptHolo() {
        if (instance != null) {
            throw new IllegalStateException();
        }
        instance = this;
    }

    public void onEnable() {
        if (!Skript.isAcceptRegistrations()) {
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            this.getLogger().severe("skript-holo can't be loaded when the server is already loaded! Plugin is disabled.");
            return;
        }
        try {
            SkriptAddon addonInstance = Skript.registerAddon((JavaPlugin)this);
            addonInstance.loadClasses("me.blueyescat.skriptholo", new String[]{"skript"});
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Metrics metrics = new Metrics(SkriptHolo.getInstance());
        metrics.addCustomChart(new Metrics.SimplePie("skript_version", () -> Skript.getInstance().getDescription().getVersion()));
        metrics.addCustomChart(new Metrics.SimplePie("holographicdisplays_version", () -> this.getServer().getPluginManager().getPlugin("HolographicDisplays").getDescription().getVersion()));
        this.getLogger().info("Started metrics!");
        this.getLogger().info("Finished loading!");
    }

    static void deleteFollowingHolograms(int entityID) {
        Map<Hologram, Vector> holoMap = followingHolograms.get(entityID);
        if (holoMap == null || holoMap.isEmpty()) {
            return;
        }
        Iterator<Map.Entry<Hologram, Vector>> iterator = holoMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Hologram, Vector> o;
            Map.Entry<Hologram, Vector> entry = o = iterator.next();
            Hologram holo = entry.getKey();
            Utils.deleteHologram(entityID, holo);
        }
    }

    public static SkriptAddon getAddonInstance() {
        if (addonInstance == null) {
            addonInstance = Skript.registerAddon((JavaPlugin)SkriptHolo.getInstance());
        }
        return addonInstance;
    }

    public static SkriptHolo getInstance() {
        if (instance == null) {
            throw new IllegalStateException();
        }
        return instance;
    }

    static {
        startedFollowingHologramTasks = false;
        followingHolograms = new HashMap<Integer, Map<Hologram, Vector>>();
        followingHologramsEntities = new ConcurrentHashMap<Entity, List<Hologram>>();
        followingHologramsList = new HashSet<Hologram>();
    }
}

