/*
 * Decompiled with CFR 0.152.
 */
package me.blueyescat.skriptholo.util;

import com.gmail.filoghost.holographicdisplays.api.Hologram;
import com.gmail.filoghost.holographicdisplays.api.line.CollectableLine;
import com.gmail.filoghost.holographicdisplays.api.line.HologramLine;
import com.gmail.filoghost.holographicdisplays.api.line.ItemLine;
import com.gmail.filoghost.holographicdisplays.api.line.TouchableLine;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import me.blueyescat.skriptholo.SkriptHolo;
import me.blueyescat.skriptholo.skript.effects.EffCreateHologram;
import me.blueyescat.skriptholo.util.HologramLinePickupEvent;
import me.blueyescat.skriptholo.util.HologramLineTouchEvent;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class Utils {
    public static boolean hasPlugin(String name) {
        return Bukkit.getServer().getPluginManager().isPluginEnabled(name);
    }

    public static Plugin getPlugin(String name) {
        return Bukkit.getServer().getPluginManager().getPlugin(name);
    }

    public static List<HologramLine> getHologramLines(Hologram holo) {
        ArrayList<HologramLine> lines = new ArrayList<HologramLine>();
        for (int l = 0; l < holo.size(); ++l) {
            lines.add(holo.getLine(l));
        }
        return lines;
    }

    public static void deleteHologram(Integer entityID, Hologram ... holograms) {
        for (Hologram holo : holograms) {
            if (!holo.isDeleted()) {
                holo.delete();
            }
            if (holo.equals(EffCreateHologram.lastCreated)) {
                EffCreateHologram.lastCreated = null;
            }
            if (Utils.isFollowingHologram(holo)) {
                Map.Entry<Object, Object> entry;
                Iterator<Map.Entry<Object, Object>> it = SkriptHolo.followingHologramsEntities.entrySet().iterator();
                while (it.hasNext()) {
                    entry = it.next();
                    List<Hologram> holoList = entry.getValue();
                    holoList.removeIf(holo2 -> holo2.equals(holo));
                    if (!holoList.isEmpty()) continue;
                    it.remove();
                }
                if (entityID == null) {
                    it = SkriptHolo.followingHolograms.entrySet().iterator();
                    while (it.hasNext()) {
                        entry = it.next();
                        Map holoMap = (Map)entry.getValue();
                        for (Map.Entry o2 : holoMap.entrySet()) {
                            Map.Entry entry2 = o2;
                            if (!entry2.getKey().equals(holo)) continue;
                            it.remove();
                        }
                    }
                } else {
                    SkriptHolo.followingHolograms.remove(entityID);
                }
            }
            SkriptHolo.followingHologramsList.remove(holo);
        }
    }

    public static void deleteHologram(Hologram ... holograms) {
        Utils.deleteHologram(null, holograms);
    }

    public static void makeHologramStartFollowing(Hologram holo, Entity entity, Vector offset) {
        SkriptHolo.followingHologramsList.add(holo);
        int entityID = entity.getEntityId();
        Map<Hologram, Vector> holoMap = SkriptHolo.followingHolograms.get(entityID);
        if (holoMap == null) {
            holoMap = new HashMap<Hologram, Vector>();
        }
        holoMap.put(holo, offset);
        SkriptHolo.followingHolograms.put(entityID, holoMap);
        List<Hologram> holoList = SkriptHolo.followingHologramsEntities.get(entity);
        if (holoList == null) {
            holoList = new ArrayList<Hologram>();
        }
        holoList.add(holo);
        SkriptHolo.followingHologramsEntities.put(entity, holoList);
        Location location = entity.getLocation().clone();
        if (offset != null) {
            location.add(offset);
        }
        if (holo.getWorld() == location.getWorld()) {
            holo.teleport(location);
        }
    }

    public static void makeHologramStopFollowing(Hologram holo) {
        Map.Entry<Integer, Object> entry;
        Iterator<Map.Entry<Integer, Object>> it = SkriptHolo.followingHolograms.entrySet().iterator();
        while (it.hasNext()) {
            entry = it.next();
            Map<Hologram, Vector> holoMap = entry.getValue();
            Iterator<Map.Entry<Hologram, Vector>> it2 = holoMap.entrySet().iterator();
            while (it2.hasNext()) {
                Hologram holo22 = it2.next().getKey();
                if (!holo22.equals(holo)) continue;
                it2.remove();
            }
            it.remove();
        }
        it = SkriptHolo.followingHologramsEntities.entrySet().iterator();
        while (it.hasNext()) {
            entry = it.next();
            List holoList = (List)entry.getValue();
            holoList.removeIf(holo2 -> holo2.equals(holo));
            if (!holoList.isEmpty()) continue;
            it.remove();
        }
        SkriptHolo.followingHologramsList.remove(holo);
    }

    public static boolean isFollowingHologram(Hologram holo) {
        return SkriptHolo.followingHologramsList.contains(holo);
    }

    public static void addTouchHandler(HologramLine line) {
        TouchableLine tl = (TouchableLine)line;
        if (tl.getTouchHandler() == null) {
            tl.setTouchHandler(player -> {
                HologramLineTouchEvent event = new HologramLineTouchEvent(player, (HologramLine)tl);
                Bukkit.getPluginManager().callEvent((Event)event);
            });
        }
    }

    public static void addPickupHandler(HologramLine line) {
        if (!(line instanceof ItemLine)) {
            return;
        }
        CollectableLine tl = (CollectableLine)line;
        if (tl.getPickupHandler() == null) {
            tl.setPickupHandler(player -> {
                HologramLinePickupEvent event = new HologramLinePickupEvent(player, (HologramLine)tl);
                Bukkit.getPluginManager().callEvent((Event)event);
            });
        }
    }
}

