/*
 * Decompiled with CFR 0.152.
 */
package me.blueyescat.skriptholo.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import com.gmail.filoghost.holographicdisplays.api.Hologram;
import java.util.ArrayList;
import java.util.Map;
import me.blueyescat.skriptholo.SkriptHolo;
import me.blueyescat.skriptholo.util.Utils;
import org.bukkit.event.Event;
import org.bukkit.util.Vector;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Following Hologram Offset")
@Description(value={"Returns offset of a following hologram. Can be set."})
@Examples(value={"delete offset of last holoset following offset of {_hologram} to vector(0.5, 2.5, 0)"})
@Since(value="1.0.0")
@RequiredPlugins(value={"ProtocolLib"})
public class ExprFollowingHologramOffset
extends SimpleExpression<Vector> {
    private Expression<Hologram> holograms;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        if (!Utils.hasPlugin("ProtocolLib")) {
            Skript.error((String)"The following hologram feature requires ProtocolLib");
            return false;
        }
        this.holograms = exprs[0];
        return true;
    }

    protected Vector[] get(Event e) {
        ArrayList<Vector> offsets = new ArrayList<Vector>();
        for (Hologram holo : (Hologram[])this.holograms.getArray(e)) {
            if (!Utils.isFollowingHologram(holo)) continue;
            for (int entityID : SkriptHolo.followingHolograms.keySet()) {
                Map<Hologram, Vector> holoMap = SkriptHolo.followingHolograms.get(entityID);
                for (Map.Entry<Hologram, Vector> o : holoMap.entrySet()) {
                    Map.Entry<Hologram, Vector> entry = o;
                    if (!entry.getKey().equals(holo) || entry.getValue() == null) continue;
                    offsets.add(entry.getValue());
                }
            }
        }
        return offsets.toArray(new Vector[0]);
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.DELETE || mode == Changer.ChangeMode.RESET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Vector.class});
        }
        return null;
    }

    public void change(Event e, @Nullable Object[] delta, Changer.ChangeMode mode) {
        for (Hologram holo : (Hologram[])this.holograms.getArray(e)) {
            if (!Utils.isFollowingHologram(holo)) continue;
            for (int entityID : SkriptHolo.followingHolograms.keySet()) {
                Map<Hologram, Vector> holoMap = SkriptHolo.followingHolograms.get(entityID);
                for (Map.Entry<Hologram, Vector> o : holoMap.entrySet()) {
                    Map.Entry<Hologram, Vector> entry = o;
                    if (!entry.getKey().equals(holo)) continue;
                    if (mode == Changer.ChangeMode.SET) {
                        entry.setValue((Vector)delta[0]);
                        continue;
                    }
                    entry.setValue(null);
                }
            }
        }
    }

    public boolean isSingle() {
        return this.holograms.isSingle();
    }

    public Class<? extends Vector> getReturnType() {
        return Vector.class;
    }

    public String toString(@Nullable Event e, boolean debug) {
        return "the offset of " + this.holograms.toString(e, debug);
    }

    static {
        Skript.registerExpression(ExprFollowingHologramOffset.class, Vector.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"[the] [following] offset[s] of [holo[gram][s]] %holograms%", "%holograms%'[s] [following] offset[s]"});
    }
}

