/*
 * Decompiled with CFR 0.152.
 */
package me.blueyescat.skriptholo.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.gmail.filoghost.holographicdisplays.api.line.HologramLine;
import me.blueyescat.skriptholo.util.Utils;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Make Hologram Line Click-able/Touchable")
@Description(value={"Makes a hologram line click-able or/and touchable. ", "", "- **Click-able:** when a player clicks on the line, the `Hologram Line Click` event will be triggered", "- **Touchable:** when a player tries to pickup the item in the line, the `Hologram Line Touch` event will be triggered", "- **Interactive:** includes both click-able and touchable"})
@Examples(value={"make 1st line of last holo click-able", "make all lines of {_holo} untouchable", "make the last line of {_hologram} non-interactive", "make line 2 of the created hologram interactive"})
@Since(value="1.0.0")
public class EffMakeHologramLineInteractive
extends Effect {
    private Expression<HologramLine> lines;
    private boolean negated;
    private boolean clickable;
    private boolean touchable;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.negated = parseResult.mark == 1;
        this.lines = exprs[0];
        this.clickable = matchedPattern == 0 || matchedPattern == 2;
        this.touchable = matchedPattern == 1 || matchedPattern == 2;
        return true;
    }

    protected void execute(Event e) {
        block9: {
            if (this.clickable) {
                if (!this.negated) {
                    for (HologramLine line : (HologramLine[])this.lines.getArray(e)) {
                        Utils.addTouchHandler(line);
                    }
                } else {
                    for (HologramLine line : (HologramLine[])this.lines.getArray(e)) {
                        Utils.addTouchHandler(line);
                    }
                }
            }
            if (!this.touchable) break block9;
            if (!this.negated) {
                for (HologramLine line : (HologramLine[])this.lines.getArray(e)) {
                    Utils.addPickupHandler(line);
                }
            } else {
                for (HologramLine line : (HologramLine[])this.lines.getArray(e)) {
                    Utils.addPickupHandler(line);
                }
            }
        }
    }

    public String toString(@Nullable Event e, boolean debug) {
        String interact = "";
        if (this.clickable && this.touchable) {
            interact = "interact-able ";
        } else if (this.clickable) {
            interact = "click-able ";
        } else if (this.touchable) {
            interact = "touchable ";
        }
        return "make " + this.lines.toString(e, debug) + (this.negated ? " non-" : " " + interact);
    }

    static {
        Skript.registerEffect(EffMakeHologramLineInteractive.class, (String[])new String[]{"(make|let) [holo[gram] line[s]] %hologramlines% [(1\u00a6(un|non[-]))]click[-]able", "(make|let) [holo[gram] line[s]] %hologramlines% [(1\u00a6(un|non[-]))]touch[-]able", "(make|let) [holo[gram] line[s]] %hologramlines% [(1\u00a6(non[-]|un))](interactive|interact[-]able)"});
    }
}

