/*
 * Decompiled with CFR 0.152.
 */
package me.blueyescat.skriptholo.skript.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.gmail.filoghost.holographicdisplays.api.Hologram;
import me.blueyescat.skriptholo.util.Utils;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Is Hologram Visible by Default")
@Description(value={"Checks whether the given hologram is visible by default."})
@Examples(value={"if {_hologram} is visible by default:", "if holograms {_list::*} are hidden by default:"})
@Since(value="1.0.0")
@RequiredPlugins(value={"ProtocolLib"})
public class CondIsHologramVisibleByDefault
extends Condition {
    private Expression<Hologram> holograms;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        if (!Utils.hasPlugin("ProtocolLib")) {
            Skript.error((String)"The hologram visibility feature requires ProtocolLib");
            return false;
        }
        this.holograms = exprs[0];
        this.setNegated(matchedPattern == 1 ^ parseResult.mark == 1);
        return true;
    }

    public boolean check(Event e) {
        return this.holograms.check(e, holo -> holo.getVisibilityManager().isVisibleByDefault(), this.isNegated());
    }

    public String toString(@Nullable Event e, boolean debug) {
        return this.holograms.toString(e, debug) + " is " + (this.isNegated() ? "not " : "") + "visible by default";
    }

    static {
        Skript.registerCondition(CondIsHologramVisibleByDefault.class, (String[])new String[]{"[holo[gram][s]] %holograms% (is|are) (visible|1\u00a6(invisible|hidden)) by default", "[holo[gram][s]] %holograms% (isn't|is not|aren't|are not) (visible|1\u00a6(invisible|hidden)) by default"});
    }
}

