/*
 * Decompiled with CFR 0.152.
 */
package me.blueyescat.skriptholo.skript.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.gmail.filoghost.holographicdisplays.api.line.HologramLine;
import com.gmail.filoghost.holographicdisplays.api.line.ItemLine;
import com.gmail.filoghost.holographicdisplays.api.line.TextLine;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Is Text/Item Line")
@Description(value={"Checks whether the given hologram line is a text line or an item line.The `Hologram Line Content` expression can be used to get the text or the item."})
@Examples(value={"if event-holo-line is a text line:", "if line 3 of holo {_variable} is an item line:", "if lines of event-holo aren't string lines:"})
@Since(value="1.0.0")
public class CondIsHologramLineTextItem
extends Condition {
    private Expression<HologramLine> lines;
    private boolean isText;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.lines = exprs[0];
        this.isText = parseResult.mark == 0;
        this.setNegated(matchedPattern == 1);
        return true;
    }

    public boolean check(Event e) {
        if (this.isText) {
            return this.lines.check(e, line -> line instanceof TextLine, this.isNegated());
        }
        return this.lines.check(e, line -> line instanceof ItemLine, this.isNegated());
    }

    public String toString(@Nullable Event e, boolean debug) {
        return this.lines.toString(e, debug) + " is " + (this.isNegated() ? "not " : "") + (this.isText ? "text" : "item") + " line";
    }

    static {
        Skript.registerCondition(CondIsHologramLineTextItem.class, (String[])new String[]{"[holo[gram] line[s]] %hologramlines% (is|are) [a[n]] ((text|string)|1\u00a6item) line[s]", "[holo[gram] line[s]] %hologramlines% (isn't|is not|aren't|are not) [a[n]] ((text|string)|1\u00a6item) line[s]"});
    }
}

