/*
 * Decompiled with CFR 0.152.
 */
package me.blueyescat.skriptholo.skript.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.gmail.filoghost.holographicdisplays.api.line.HologramLine;
import com.gmail.filoghost.holographicdisplays.api.line.TouchableLine;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Is Hologram Line Click-able")
@Description(value={"Checks whether the given hologram line is click-able."})
@Examples(value={"if line 3 of {_hologram} is click-able:"})
@Since(value="1.0.0")
public class CondIsHologramLineClickable
extends Condition {
    private Expression<HologramLine> lines;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.lines = exprs[0];
        this.setNegated(matchedPattern == 1 ^ parseResult.mark == 1);
        return true;
    }

    public boolean check(Event e) {
        return this.lines.check(e, line -> line instanceof TouchableLine && ((TouchableLine)line).getTouchHandler() != null, this.isNegated());
    }

    public String toString(@Nullable Event e, boolean debug) {
        return this.lines.toString(e, debug) + " is " + (this.isNegated() ? "not " : "") + "click-able";
    }

    static {
        Skript.registerCondition(CondIsHologramLineClickable.class, (String[])new String[]{"[holo[gram] line[s]] %hologramlines% (is|are) [(1\u00a6(un|non[-]))]click[-]able", "[holo[gram] line[s]] %hologramlines% (isn't|is not|aren't|are not) [(1\u00a6(un|non[-]))]click[-]able"});
    }
}

