/*
 * Decompiled with CFR 0.152.
 */
package me.blueyescat.skriptholo.skript.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.gmail.filoghost.holographicdisplays.api.Hologram;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Is Hologram Deleted")
@Description(value={"Checks whether the given hologram is deleted. When you delete a hologram that is stored in a variable, the hologram object will still exist in the variable but will not be usable. This condition exists to check this case."})
@Examples(value={"if hologram {variable} is deleted:"})
@Since(value="1.0.0")
public class CondIsHologramDeleted
extends Condition {
    private Expression<Hologram> holograms;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.holograms = exprs[0];
        this.setNegated(matchedPattern == 1);
        return true;
    }

    public boolean check(Event e) {
        return this.holograms.check(e, Hologram::isDeleted, this.isNegated());
    }

    public String toString(@Nullable Event e, boolean debug) {
        return this.holograms.toString(e, debug) + " is " + (this.isNegated() ? "not " : "") + "deleted";
    }

    static {
        Skript.registerCondition(CondIsHologramDeleted.class, (String[])new String[]{"holo[gram][s] %holograms% (is|are) (deleted|removed|cleared)", "holo[gram][s] %holograms% (isn't|is not|aren't|are not) (deleted|removed|cleared)"});
    }
}

