/*
 * Decompiled with CFR 0.152.
 */
package me.blueyescat.skriptholo.skript.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.gmail.filoghost.holographicdisplays.api.Hologram;
import me.blueyescat.skriptholo.util.Utils;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Is Following Hologram")
@Description(value={"Checks whether the given hologram is a following hologram."})
@Examples(value={"if {_holo} is a following hologram:"})
@Since(value="1.0.0")
public class CondIsFollowingHologram
extends Condition {
    private Expression<Hologram> holograms;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.holograms = exprs[0];
        this.setNegated(matchedPattern == 1);
        return true;
    }

    public boolean check(Event e) {
        return this.holograms.check(e, Utils::isFollowingHologram, this.isNegated());
    }

    public String toString(@Nullable Event e, boolean debug) {
        return this.holograms.toString(e, debug) + " is " + (this.isNegated() ? "not " : "") + "following";
    }

    static {
        Skript.registerCondition(CondIsFollowingHologram.class, (String[])new String[]{"[holo[gram][s]] %holograms% (is|are) [a] following [holo[gram][s]]", "[holo[gram][s]] %holograms% (isn't|is not|aren't|are not) [a] following [holo[gram][s]]"});
    }
}

