/*
 * Decompiled with CFR 0.152.
 */
package me.blueyescat.skriptholo;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptAddon;
import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.ProtocolManager;
import com.comphenix.protocol.events.ListenerPriority;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.events.PacketListener;
import com.gmail.filoghost.holographicdisplays.api.Hologram;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import me.blueyescat.skriptholo.skript.effects.EffCreateHologram;
import me.blueyescat.skriptholo.util.Metrics;
import me.blueyescat.skriptholo.util.Utils;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class SkriptHolo
extends JavaPlugin
implements Listener {
    private static SkriptHolo instance;
    private static SkriptAddon addonInstance;
    public static boolean startedFollowingHologramTasks;
    public static Map<Integer, Map<Hologram, Vector>> followingHolograms;
    public static Map<Entity, List<Hologram>> followingHologramsEntities;
    public static Set<Hologram> followingHologramsList;

    public SkriptHolo() {
        if (instance != null) {
            throw new IllegalStateException();
        }
        instance = this;
    }

    public void onEnable() {
        if (!Skript.isAcceptRegistrations()) {
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            this.getLogger().severe("skript-holo can't be loaded when the server is already loaded! Plugin is disabled.");
            return;
        }
        try {
            SkriptAddon addonInstance = Skript.registerAddon((JavaPlugin)this);
            addonInstance.loadClasses("me.blueyescat.skriptholo", new String[]{"skript"});
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Metrics metrics = new Metrics(SkriptHolo.getInstance());
        metrics.addCustomChart(new Metrics.SimplePie("skript_version", () -> Skript.getInstance().getDescription().getVersion()));
        metrics.addCustomChart(new Metrics.SimplePie("holographicdisplays_version", () -> this.getServer().getPluginManager().getPlugin("HolographicDisplays").getDescription().getVersion()));
        this.getLogger().info("Started metrics!");
        this.getLogger().info("Finished loading!");
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent event) {
        int entityID = event.getPlayer().getEntityId();
        Map<Hologram, Vector> holoMap = followingHolograms.get(entityID);
        if (holoMap == null || holoMap.isEmpty()) {
            return;
        }
        for (Map.Entry<Hologram, Vector> o : holoMap.entrySet()) {
            Map.Entry<Hologram, Vector> entry = o;
            Hologram holo = entry.getKey();
            if (holo.isDeleted()) {
                holoMap.remove(holo);
                return;
            }
            Player player = event.getPlayer();
            if (!holo.getVisibilityManager().isVisibleTo(player)) {
                return;
            }
            Location location = event.getTo().clone();
            if (entry.getValue() != null) {
                location.add(entry.getValue());
            }
            if (holo.getWorld() != location.getWorld() && holo.getLocation().distance(location) == 0.0) continue;
            holo.teleport(location);
        }
    }

    private static void deleteFollowingHolograms(int entityID) {
        Map<Hologram, Vector> holoMap = followingHolograms.get(entityID);
        if (holoMap == null || holoMap.isEmpty()) {
            return;
        }
        Iterator<Map.Entry<Hologram, Vector>> iterator = holoMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Hologram, Vector> o;
            Map.Entry<Hologram, Vector> entry = o = iterator.next();
            Hologram holo = entry.getKey();
            Utils.deleteHologram(entityID, holo);
        }
    }

    public static void startFollowingHologramTasks() {
        if (startedFollowingHologramTasks) {
            return;
        }
        startedFollowingHologramTasks = true;
        Bukkit.getPluginManager().registerEvents((Listener)SkriptHolo.getInstance(), (Plugin)SkriptHolo.getInstance());
        ProtocolManager protocolManager = ProtocolLibrary.getProtocolManager();
        protocolManager.addPacketListener((PacketListener)new PacketAdapter((Plugin)SkriptHolo.getInstance(), ListenerPriority.NORMAL, new PacketType[]{PacketType.Play.Server.REL_ENTITY_MOVE, PacketType.Play.Server.REL_ENTITY_MOVE_LOOK, PacketType.Play.Server.ENTITY_TELEPORT}){

            public void onPacketSending(PacketEvent event) {
                int entityID = (Integer)event.getPacket().getIntegers().read(0);
                Map<Hologram, Vector> holoMap = followingHolograms.get(entityID);
                if (holoMap == null || holoMap.isEmpty()) {
                    return;
                }
                for (Map.Entry<Hologram, Vector> o : holoMap.entrySet()) {
                    Entity entity;
                    Map.Entry<Hologram, Vector> entry = o;
                    Hologram holo = entry.getKey();
                    if (holo.isDeleted()) {
                        holoMap.remove(holo);
                        continue;
                    }
                    Player player = event.getPlayer();
                    if (player.equals(entity = (Entity)event.getPacket().getEntityModifier(event).getValues().get(0)) && !holo.getVisibilityManager().isVisibleTo(player)) continue;
                    Location location = entity.getLocation().clone();
                    if (entry.getValue() != null) {
                        location.add(entry.getValue());
                    }
                    if (holo.getWorld() != location.getWorld() && holo.getLocation().distance(location) == 0.0) continue;
                    holo.teleport(location);
                }
            }
        });
        protocolManager.addPacketListener((PacketListener)new PacketAdapter((Plugin)SkriptHolo.getInstance(), ListenerPriority.NORMAL, new PacketType[]{PacketType.Play.Server.ENTITY_DESTROY}){

            public void onPacketSending(PacketEvent event) {
                for (int entityID : (int[])event.getPacket().getIntegerArrays().read(0)) {
                    SkriptHolo.deleteFollowingHolograms(entityID);
                }
            }
        });
        new BukkitRunnable(){

            public void run() {
                for (Map.Entry<Entity, List<Hologram>> o : followingHologramsEntities.entrySet()) {
                    Map.Entry<Entity, List<Hologram>> entry = o;
                    Entity entity = entry.getKey();
                    if (entity.isValid()) continue;
                    for (Hologram holo : entry.getValue()) {
                        if (!holo.isDeleted()) {
                            holo.delete();
                        }
                        if (holo.equals(EffCreateHologram.lastCreated)) {
                            EffCreateHologram.lastCreated = null;
                        }
                        followingHologramsList.remove(holo);
                    }
                    followingHologramsEntities.remove(entity);
                    followingHolograms.remove(entity.getEntityId());
                }
            }
        }.runTaskTimerAsynchronously((Plugin)SkriptHolo.getInstance(), 60L, 0L);
    }

    public static SkriptAddon getAddonInstance() {
        if (addonInstance == null) {
            addonInstance = Skript.registerAddon((JavaPlugin)SkriptHolo.getInstance());
        }
        return addonInstance;
    }

    public static SkriptHolo getInstance() {
        if (instance == null) {
            throw new IllegalStateException();
        }
        return instance;
    }

    static {
        startedFollowingHologramTasks = false;
        followingHolograms = new HashMap<Integer, Map<Hologram, Vector>>();
        followingHologramsEntities = new ConcurrentHashMap<Entity, List<Hologram>>();
        followingHologramsList = new HashSet<Hologram>();
    }
}

