/*
 * Decompiled with CFR 0.152.
 */
package io.github.apickledwalrus.skriptgui.util;

import org.bukkit.Bukkit;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.eclipse.jdt.annotation.Nullable;

public class InventoryUtils {
    @Nullable
    public static Inventory getOppositeInventory(InventoryView view, Inventory inv) {
        if (view == null || inv == null) {
            return null;
        }
        if (view.getTopInventory().equals(inv)) {
            return view.getBottomInventory();
        }
        if (view.getBottomInventory().equals(inv)) {
            return view.getTopInventory();
        }
        return null;
    }

    public static int getSlotTo(Inventory invTo, ItemStack item) {
        if (item == null || invTo.first(item.getType()) < 0) {
            return invTo.firstEmpty();
        }
        for (int i = invTo.first(item.getType()); i < invTo.getSize(); ++i) {
            if (!InventoryUtils.isSimilar(item, invTo.getItem(i))) continue;
            return i;
        }
        return invTo.firstEmpty();
    }

    public static int getInvertedSlotTo(Inventory invTo, ItemStack item) {
        int i;
        for (i = 8; i >= 0; --i) {
            if (!InventoryUtils.isSimilar(item, invTo.getItem(i))) continue;
            return i;
        }
        for (i = invTo.getSize() - 1; i > 8; --i) {
            if (!InventoryUtils.isSimilar(item, invTo.getItem(i))) continue;
            return i;
        }
        return -1;
    }

    public static Inventory newInventory(InventoryType type, @Nullable Integer size, @Nullable String name) {
        size = size == null || size == 0 ? type.getDefaultSize() : size * 9;
        if (name == null) {
            name = type.getDefaultTitle();
        } else if (name.length() > 32) {
            name = name.substring(0, 32);
        }
        if (type == InventoryType.CHEST) {
            return Bukkit.getServer().createInventory(null, size.intValue(), name);
        }
        return Bukkit.getServer().createInventory(null, type, name);
    }

    public static boolean isSimilar(ItemStack one, ItemStack two) {
        if (one == null || two == null) {
            return false;
        }
        boolean sameMaterial = one.getType() == two.getType();
        boolean sameAmount = one.getAmount() == two.getAmount();
        boolean sameMeta = Bukkit.getItemFactory().equals(one.getItemMeta(), two.getItemMeta());
        boolean sameEnchantments = one.getEnchantments().equals(two.getEnchantments());
        return sameMaterial && sameAmount && sameMeta && sameEnchantments;
    }
}

