/*
 * Decompiled with CFR 0.152.
 */
package io.github.apickledwalrus.skriptgui.gui;

import io.github.apickledwalrus.skriptgui.gui.GUI;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.WeakHashMap;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

public class GUIManager {
    private final Map<String, GUI> globalGUIs = new HashMap<String, GUI>();
    private final WeakHashMap<Event, GUI> eventGUIs = new WeakHashMap();
    private final Map<UUID, GUI> players = new HashMap<UUID, GUI>();

    public GUI getGUIEvent(Event e) {
        return this.eventGUIs.get(e);
    }

    public void setGUIEvent(Event e, @Nullable GUI gui) {
        if (gui != null) {
            this.eventGUIs.put(e, gui);
        } else {
            this.eventGUIs.remove(e);
        }
    }

    @Nullable
    public GUI getGlobalGUI(String id) {
        return id != null ? this.globalGUIs.get(id) : null;
    }

    public void addGlobalGUI(String id, GUI gui) {
        if (id != null && gui != null) {
            this.globalGUIs.put(id, gui);
        }
    }

    @Nullable
    public GUI removeGlobalGUI(String id) {
        return this.globalGUIs.remove(id);
    }

    public void setGUI(Player p, GUI gui) {
        this.players.put(p.getUniqueId(), gui);
    }

    @Nullable
    public GUI getGUI(Player p) {
        return this.players.get(p.getUniqueId());
    }

    public void removeGUI(Player p) {
        this.players.remove(p.getUniqueId());
    }

    public boolean hasGUI(Player p) {
        return this.players.containsKey(p.getUniqueId());
    }
}

