/*
 * Decompiled with CFR 0.152.
 */
package io.github.apickledwalrus.skriptgui.gui;

import ch.njol.skript.Skript;
import io.github.apickledwalrus.skriptgui.SkriptGUI;
import io.github.apickledwalrus.skriptgui.gui.GUIListener;
import io.github.apickledwalrus.skriptgui.util.InventoryUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.eclipse.jdt.annotation.Nullable;

public class GUI {
    private final Consumer<InventoryClickEvent> NULL_CONSUMER;
    private Inventory guiInventory;
    private GUIListener listener;
    private String name;
    private String rawShape;
    private final Map<Character, Consumer<InventoryClickEvent>> slots;
    private Consumer<InventoryCloseEvent> onClose;
    private boolean stealableItems;
    private final List<Character> stealableSlots;
    private boolean closeCancelled;

    public GUI(Inventory inv) {
        this.NULL_CONSUMER = e -> {};
        this.slots = new HashMap<Character, Consumer<InventoryClickEvent>>();
        this.stealableSlots = new ArrayList<Character>();
        this.guiInventory = inv;
        this.name = inv.getType().getDefaultTitle();
        this.stealableItems = false;
    }

    public GUI(Inventory inv, boolean stealableItems) {
        this.NULL_CONSUMER = e -> {};
        this.slots = new HashMap<Character, Consumer<InventoryClickEvent>>();
        this.stealableSlots = new ArrayList<Character>();
        this.guiInventory = inv;
        this.name = inv.getType().getDefaultTitle();
        this.stealableItems = stealableItems;
    }

    public GUI(Inventory inv, boolean stealableItems, String name) {
        this.NULL_CONSUMER = e -> {};
        this.slots = new HashMap<Character, Consumer<InventoryClickEvent>>();
        this.stealableSlots = new ArrayList<Character>();
        this.guiInventory = inv;
        this.name = name;
        this.stealableItems = stealableItems;
    }

    public Inventory getInventory() {
        if (!this.getListener().isStarted()) {
            this.getListener().start();
        }
        return this.guiInventory;
    }

    public char convertSlot(int slot) {
        if (slot < this.getRawShape().length()) {
            return this.getRawShape().charAt(slot);
        }
        return ' ';
    }

    public char nextSlot() {
        for (char ch : this.rawShape.toCharArray()) {
            if (this.slots.containsKey(Character.valueOf(ch))) continue;
            return ch;
        }
        return '\u0000';
    }

    public char nextInvertedSlot() {
        for (char ch2 : this.rawShape.toCharArray()) {
            if (!this.slots.containsKey(Character.valueOf(ch2))) continue;
            return ch2;
        }
        return '\u0000';
    }

    private char convert(Object slot) {
        char ch = slot instanceof Number ? this.convertSlot(((Number)slot).intValue()) : (slot instanceof String && !((String)slot).isEmpty() ? ((String)slot).charAt(0) : (slot instanceof Character ? ((Character)slot).charValue() : this.nextSlot()));
        return ch;
    }

    public GUI clear() {
        int x = -1;
        for (char ch : this.rawShape.toCharArray()) {
            if (++x >= this.getInventory().getSize() || !this.slots.containsKey(Character.valueOf(ch))) continue;
            this.setItem(Character.valueOf(ch), new ItemStack(Material.AIR), null);
        }
        this.slots.clear();
        this.stealableSlots.clear();
        return this;
    }

    public GUI clearSlots(Object ... chars) {
        if (chars != null && chars.length > 0) {
            for (Object ch : chars) {
                char ch1 = this.convert(ch);
                int x = -1;
                for (char ch2 : this.rawShape.toCharArray()) {
                    if (++x >= this.getInventory().getSize() || ch1 != ch2) continue;
                    this.setItem(ch, new ItemStack(Material.AIR), null);
                }
                this.slots.remove(Character.valueOf(ch1));
                this.stealableSlots.remove(ch1);
            }
        }
        return this;
    }

    public GUI setName(String newName) {
        if (newName == null) {
            return this;
        }
        Inventory inv = InventoryUtils.newInventory(this.getInventory().getType(), this.getInventory().getSize() / 9, newName);
        inv.setContents(this.getInventory().getContents());
        new ArrayList<HumanEntity>(this.getInventory().getViewers()).forEach(viewer -> {
            ItemStack cursor = viewer.getItemOnCursor();
            viewer.setItemOnCursor(null);
            viewer.openInventory(inv);
            viewer.setItemOnCursor(cursor);
        });
        this.guiInventory = inv;
        this.getListener().setInventory(this.guiInventory);
        this.name = newName;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public GUI setSize(int newSize) {
        if (this.getInventory().getType() != InventoryType.CHEST) {
            return this;
        }
        Inventory inv = InventoryUtils.newInventory(this.getInventory().getType(), newSize, this.getName());
        if (newSize < this.getSize()) {
            for (int i = 0; i < inv.getSize(); ++i) {
                inv.setItem(i, this.getInventory().getItem(i));
            }
            this.rawShape = this.rawShape.substring(0, inv.getSize());
        } else {
            inv.setContents(this.getInventory().getContents());
        }
        new ArrayList<HumanEntity>(this.getInventory().getViewers()).forEach(viewer -> {
            ItemStack cursor = viewer.getItemOnCursor();
            viewer.setItemOnCursor(null);
            viewer.openInventory(inv);
            viewer.setItemOnCursor(cursor);
        });
        this.guiInventory = inv;
        this.getListener().setInventory(this.guiInventory);
        return this;
    }

    public int getSize() {
        return this.getInventory().getSize();
    }

    public GUI setShape(Boolean defaultShape, ShapeMode shapeMode, String ... shapes) {
        if (defaultShape.booleanValue()) {
            StringBuilder sb = new StringBuilder();
            for (char c = 'A'; c < this.getSize() + 65; c = (char)(c + '\u0001')) {
                sb.append(c);
            }
            this.rawShape = sb.toString();
        } else if (shapes.length > 0 && shapeMode != null) {
            StringBuilder sb = new StringBuilder();
            for (String shape : shapes) {
                sb.append(shape);
            }
            while (sb.length() < this.getSize()) {
                sb.append(' ');
            }
            String newRawShape = sb.toString();
            if (shapeMode == ShapeMode.ITEMS || shapeMode == ShapeMode.BOTH) {
                this.updateShape(newRawShape);
            }
            if (shapeMode == ShapeMode.ACTIONS || shapeMode == ShapeMode.BOTH) {
                this.rawShape = newRawShape;
            }
        }
        return this;
    }

    private void updateShape(String newRawShape) {
        int x = 0;
        HashMap<Character, ItemStack> items = new HashMap<Character, ItemStack>();
        for (char ch : this.rawShape.toCharArray()) {
            if (x >= this.getSize()) break;
            items.put(Character.valueOf(ch), this.getInventory().getItem(x));
            ++x;
        }
        ItemStack[] newContents = new ItemStack[this.getSize()];
        x = 0;
        for (char ch : newRawShape.toCharArray()) {
            ItemStack item = (ItemStack)items.get(Character.valueOf(ch));
            if (item != null && x < this.getSize()) {
                newContents[x] = item;
            }
            ++x;
        }
        this.getInventory().setContents(newContents);
    }

    public String getRawShape() {
        return this.rawShape;
    }

    public GUI setStealable(Boolean stealable) {
        this.stealableItems = stealable;
        return this;
    }

    public boolean isStealable() {
        return this.stealableItems;
    }

    public boolean isStealable(char slot) {
        return this.stealableSlots.contains(Character.valueOf(slot));
    }

    public GUI setOnClose(Consumer<InventoryCloseEvent> consumer) {
        this.onClose = consumer;
        return this;
    }

    @Nullable
    public Consumer<InventoryCloseEvent> getOnClose() {
        return this.onClose;
    }

    public boolean hasOnClose() {
        return this.onClose != null;
    }

    public void setCloseCancelled(boolean cancel) {
        this.closeCancelled = cancel;
    }

    public boolean isCloseCancelled() {
        return this.closeCancelled;
    }

    public GUI setItem(Object slot, ItemStack item, @Nullable Consumer<InventoryClickEvent> consumer) {
        return this.setItem(slot, item, false, consumer);
    }

    public GUI setItem(Object slot, ItemStack item, boolean stealable, @Nullable Consumer<InventoryClickEvent> consumer) {
        char ch = this.convert(slot);
        if (consumer == null) {
            consumer = this.NULL_CONSUMER;
        }
        if (ch == '\u0000') {
            return this;
        }
        if (ch == '+' && this.rawShape.contains("+")) {
            char ch2 = 'A';
            while (this.rawShape.indexOf(ch2) >= 0) {
                ch2 = (char)(ch2 + 1);
            }
            this.rawShape = this.rawShape.replaceFirst("\\+", "" + ch2);
            ch = ch2;
        }
        this.slots.put(Character.valueOf(ch), consumer);
        if (stealable) {
            this.stealableSlots.add(Character.valueOf(ch));
        } else {
            this.stealableSlots.remove(Character.valueOf(ch));
        }
        int x = 0;
        for (char ch1 : this.rawShape.toCharArray()) {
            if (ch == ch1 && x < this.getSize()) {
                this.getInventory().setItem(x, item);
            }
            ++x;
        }
        return this;
    }

    @Nullable
    public Consumer<InventoryClickEvent> getSlot(int slot) {
        return slot >= 0 ? this.getSlot(this.convertSlot(slot)) : this.NULL_CONSUMER;
    }

    public Consumer<InventoryClickEvent> getSlot(char ch) {
        if (ch > '\u0000' && this.slots.containsKey(Character.valueOf(ch))) {
            return this.slots.get(Character.valueOf(ch));
        }
        return this.NULL_CONSUMER;
    }

    public GUIListener getListener() {
        if (this.listener == null) {
            this.listener = new GUIListener(this.guiInventory){

                @Override
                public void onClick(InventoryClickEvent e, int slot) {
                    char realSlot = GUI.this.convertSlot(slot);
                    Consumer<InventoryClickEvent> run = GUI.this.getSlot(realSlot);
                    e.setCancelled(run != GUI.this.NULL_CONSUMER || !GUI.this.isStealable() && !GUI.this.isStealable(realSlot));
                    if (run != null && slot == e.getSlot() && GUI.this.guiInventory.equals(e.getClickedInventory())) {
                        run.accept(e);
                    }
                }

                @Override
                public void onOpen(InventoryOpenEvent e) {
                    SkriptGUI.getGUIManager().setGUI((Player)e.getPlayer(), GUI.this);
                }

                @Override
                public void onClose(final InventoryCloseEvent e) {
                    if (!GUI.this.hasOnClose()) {
                        SkriptGUI.getGUIManager().removeGUI((Player)e.getPlayer());
                    } else {
                        SkriptGUI.getGUIManager().setGUIEvent((Event)e, GUI.this);
                        if (GUI.this.getOnClose() != null) {
                            try {
                                GUI.this.getOnClose().accept(e);
                                if (GUI.this.isCloseCancelled()) {
                                    new BukkitRunnable(){

                                        public void run() {
                                            e.getPlayer().openInventory(GUI.this.getInventory());
                                            GUI.this.setCloseCancelled(false);
                                        }
                                    }.runTaskLater((Plugin)SkriptGUI.getInstance(), 1L);
                                } else {
                                    SkriptGUI.getGUIManager().removeGUI((Player)e.getPlayer());
                                }
                            }
                            catch (Exception ex) {
                                throw Skript.exception((Throwable)ex, (String[])new String[]{"An error occurred while closing a GUI. If you are unsure why this occured, please report the error on the skript-gui GitHub."});
                            }
                        }
                    }
                }

                @Override
                public void onDrag(InventoryDragEvent e, int slot) {
                    char realSlot = GUI.this.convertSlot(slot);
                    Consumer<InventoryClickEvent> run = GUI.this.getSlot(realSlot);
                    e.setCancelled(run != GUI.this.NULL_CONSUMER || !GUI.this.isStealable() && !GUI.this.isStealable(realSlot));
                }
            };
        }
        return this.listener;
    }

    public static enum ShapeMode {
        ITEMS,
        ACTIONS,
        BOTH;

    }
}

