/*
 * Decompiled with CFR 0.152.
 */
package io.github.apickledwalrus.skriptgui.elements.sections;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import io.github.apickledwalrus.skriptgui.SkriptGUI;
import io.github.apickledwalrus.skriptgui.elements.sections.SecCreateGUI;
import io.github.apickledwalrus.skriptgui.gui.GUI;
import io.github.apickledwalrus.skriptgui.util.EffectSection;
import io.github.apickledwalrus.skriptgui.util.VariableUtils;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

@Name(value="Set GUI Slots")
@Description(value={"Set or clear GUI slots."})
@Examples(value={"create a gui with virtual chest inventory with 3 rows named \"My GUI\"", "\tmake gui next gui with dirt # Formats the next available GUI slot with dirt. Doesn't do anything when clicked on.", "\tmake gui 10 with water bucket:", "\t\t#code here is run when the gui slot is clicked", "\tunformat gui 10 # Removes the GUI item at slot 10", "\tunformat the next gui # Removes the GUI item at the slot before the next available slot."})
@Since(value="1.0.0, 1.2.0 (making specific slots stealable)")
public class SecMakeGUI
extends EffectSection {
    public static SecMakeGUI lastInstance;
    private Expression<Object> slots;
    private Expression<ItemType> item;
    private int pattern;
    private boolean stealable;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        if (this.checkIfCondition()) {
            return false;
        }
        if (!SecMakeGUI.isCurrentSection(SecCreateGUI.class)) {
            Skript.error((String)"You can't make a GUI slot outside of a GUI creation or editing section.");
            return false;
        }
        this.pattern = matchedPattern;
        if (matchedPattern < 2) {
            this.item = exprs[matchedPattern];
        }
        if (matchedPattern == 1 || matchedPattern == 3) {
            this.slots = exprs[0];
        }
        boolean bl = this.stealable = parseResult.mark == 1;
        if (this.hasSection()) {
            this.loadSection("gui effect", false, InventoryClickEvent.class);
        }
        return true;
    }

    @Override
    public void execute(Event e) {
        GUI gui = SkriptGUI.getGUIManager().getGUIEvent(e);
        if (gui == null) {
            return;
        }
        switch (this.pattern) {
            case 0: 
            case 1: {
                Object[] objectArray;
                ItemType itemType = (ItemType)this.item.getSingle(e);
                if (itemType == null) break;
                ItemStack item = itemType.getRandom();
                if (this.slots != null) {
                    objectArray = this.slots.getArray(e);
                } else {
                    Object[] objectArray2 = new Object[1];
                    objectArray = objectArray2;
                    objectArray2[0] = Character.valueOf(gui.nextSlot());
                }
                for (Object slot : objectArray) {
                    if (this.hasSection()) {
                        Object variables = VariableUtils.getInstance().copyVariables(e);
                        gui.setItem(slot, item, this.stealable, event -> {
                            VariableUtils.getInstance().pasteVariables((Event)event, variables);
                            SkriptGUI.getGUIManager().setGUIEvent((Event)event, gui);
                            this.runSection((Event)event);
                        });
                        continue;
                    }
                    gui.setItem(slot, item, this.stealable, null);
                }
                break;
            }
            case 2: {
                gui.clearSlots(Character.valueOf(gui.nextInvertedSlot()));
                break;
            }
            case 3: {
                gui.clearSlots(this.slots.getArray(e));
                break;
            }
            case 4: {
                gui.clear();
            }
        }
    }

    public String toString(Event e, boolean debug) {
        switch (this.pattern) {
            case 0: {
                return "make next gui slot with " + this.item.toString(e, debug);
            }
            case 1: {
                return "make gui slot(s) " + this.slots.toString(e, debug) + " with " + this.item.toString(e, debug);
            }
            case 2: {
                return "remove the next gui slot";
            }
            case 3: {
                return "remove gui slot(s) " + this.slots.toString(e, debug);
            }
            case 4: {
                return "remove all of the gui slots";
            }
        }
        return "make gui";
    }

    static {
        Skript.registerCondition(SecMakeGUI.class, (String[])new String[]{"(make|format) [the] next gui [slot] (with|to) [(1\u00a6(moveable|stealable))] %itemtype%", "(make|format) gui [slot[s]] %strings/numbers% (with|to) [(1\u00a6(moveable|stealable))] %itemtype%", "(un(make|format)|remove) [the] next gui [slot]", "(un(make|format)|remove) gui [slot[s]] %strings/numbers%", "(un(make|format)|remove) all [of the] gui [slots]"});
        lastInstance = null;
    }
}

