/*
 * Decompiled with CFR 0.152.
 */
package io.github.apickledwalrus.skriptgui.elements.sections;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import io.github.apickledwalrus.skriptgui.SkriptGUI;
import io.github.apickledwalrus.skriptgui.elements.expressions.ExprVirtualInventory;
import io.github.apickledwalrus.skriptgui.gui.GUI;
import io.github.apickledwalrus.skriptgui.gui.SkriptGUIEvent;
import io.github.apickledwalrus.skriptgui.util.EffectSection;
import org.bukkit.event.Event;
import org.bukkit.inventory.Inventory;

@Name(value="Create / Edit GUI")
@Description(value={"The base of creating and editing GUIs."})
@Examples(value={"create a gui with virtual chest inventory with 3 rows named \"My GUI\"", "edit gui last gui:", "\tset the gui-inventory-name to \"New GUI Name!\""})
@Since(value="1.0.0")
public class SecCreateGUI
extends EffectSection {
    private Expression<GUI> exprGUI;
    private Expression<Inventory> inv;
    private Expression<String> shape;
    private Expression<String> id;
    private boolean moveableItems;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        if (this.checkIfCondition()) {
            return false;
        }
        if (matchedPattern == 1) {
            if (!this.hasSection()) {
                Skript.error((String)"You can't edit a gui inventory using an empty section, you need to change at least a slot or a property.");
                return false;
            }
            this.exprGUI = exprs[0];
        } else {
            this.id = exprs[0];
            this.inv = exprs[1];
            this.shape = exprs[2];
            boolean bl = this.moveableItems = parseResult.mark == 1;
        }
        if (this.hasSection()) {
            this.loadSection(true);
        }
        SkriptGUIEvent.getInstance().register();
        return true;
    }

    @Override
    public void execute(Event e) {
        if (this.exprGUI == null) {
            Inventory inv = (Inventory)this.inv.getSingle(e);
            if (inv != null) {
                String id;
                GUI gui = this.inv instanceof ExprVirtualInventory ? new GUI(inv, this.moveableItems, ((ExprVirtualInventory)this.inv).getName()) : new GUI(inv, this.moveableItems);
                if (this.shape == null) {
                    gui.setShape(true, null, new String[0]);
                } else {
                    gui.setShape(false, GUI.ShapeMode.ACTIONS, (String[])this.shape.getArray(e));
                }
                String string = id = this.id != null ? (String)this.id.getSingle(e) : null;
                if (id != null && !id.isEmpty()) {
                    SkriptGUI.getGUIManager().addGlobalGUI(id, gui);
                }
                SkriptGUI.getGUIManager().setGUIEvent(e, gui);
            }
        } else {
            GUI gui = (GUI)this.exprGUI.getSingle(e);
            SkriptGUI.getGUIManager().setGUIEvent(e, gui);
        }
        if (this.hasSection()) {
            this.runSection(e);
        }
    }

    public String toString(Event e, boolean debug) {
        if (this.exprGUI != null) {
            return "edit GUI " + this.exprGUI.toString(e, debug);
        }
        return "create gui";
    }

    static {
        Skript.registerCondition(SecCreateGUI.class, (String[])new String[]{"create [a] [new] gui [[with id] %-string%] with %inventory% [(1\u00a6(and|with) (moveable|stealable) items)] [(and|with) shape %-strings%]", "(change|edit) [gui] %guiinventory%"});
    }
}

