/*
 * Decompiled with CFR 0.152.
 */
package io.github.apickledwalrus.skriptgui.elements.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import io.github.apickledwalrus.skriptgui.SkriptGUI;
import io.github.apickledwalrus.skriptgui.elements.sections.SecOnCloseGUI;
import io.github.apickledwalrus.skriptgui.util.EffectSection;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Cancel GUI Close")
@Description(value={"Cancels or uncancels the closing of a GUI.", " This effect can be used within a GUI close section.", " A 1 tick delay is applied by this effect."})
@Examples(value={"create a gui with virtual chest inventory with 3 rows named \"My GUI\"", "\trun on gui close:", "\t\tcancel the gui closing"})
@Since(value="1.2.0")
public class EffCancelGUIClose
extends Effect {
    private boolean cancel;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        if (!EffectSection.isCurrentSection(SecOnCloseGUI.class)) {
            Skript.error((String)"Canceling or uncanceling the closing of a GUI can only be done within a GUI close section.");
            return false;
        }
        this.cancel = parseResult.mark == 0;
        return true;
    }

    protected void execute(Event e) {
        SkriptGUI.getGUIManager().getGUIEvent(e).setCloseCancelled(this.cancel);
    }

    public String toString(@Nullable Event e, boolean debug) {
        return (this.cancel ? "cancel" : "uncancel") + " the gui closing";
    }

    static {
        Skript.registerEffect(EffCancelGUIClose.class, (String[])new String[]{"(cancel|1\u00c2\u00a6uncancel) [the] gui clos(e|ing)"});
    }
}

