/*
 * Decompiled with CFR 0.152.
 */
package io.github.apickledwalrus.skriptgui.elements.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import io.github.apickledwalrus.skriptgui.SkriptGUI;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

@Name(value="Has GUI")
@Description(value={"Checks whether the given player(s) has/have a GUI open."})
@Examples(value={"command /guiviewers: # Returns a list of all players with a GUI open.", "\tset {_viewers::*} to all players where [input has a gui]", "\tsend \"GUI Viewers: %{_viewers::*}%\" to player"})
@Since(value="1.0.0")
public class CondHasGUI
extends Condition {
    private Expression<Player> players;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.players = exprs[0];
        this.setNegated(matchedPattern % 2 != 0);
        return true;
    }

    public boolean check(Event e) {
        return this.players.check(e, p -> SkriptGUI.getGUIManager().hasGUI((Player)p), this.isNegated());
    }

    public String toString(Event e, boolean debug) {
        return this.players.toString(e, debug) + (!this.isNegated() ? " has/have " : " do not/don't have ") + " a gui open";
    }

    static {
        Skript.registerCondition(CondHasGUI.class, (String[])new String[]{"%players% (has|have) a gui [open]", "%players% (doesn't|does not|do not|don't) have a gui [open]"});
    }
}

