/*
 * Decompiled with CFR 0.152.
 */
package io.github.apickledwalrus.skriptgui.elements.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.UnparsedLiteral;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import java.util.ArrayList;
import org.bukkit.event.Event;

@Name(value="Paginated List")
@Description(value={"Returns the \"pages\" of a list based on the given number of lines per page."})
@Examples(value={"# The SECOND set of 36 items in the \"guiItems\" list. This represents the elements from indexes 37 to 72", "set {_guiPage2::*} to page 2 of {_guiItems::*} with 36 lines"})
@Since(value="1.1.0")
public class ExprPaginatedList
extends SimpleExpression<Object> {
    private Expression<Number> pages;
    private Expression<?> contents;
    private Expression<Number> lines;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.pages = exprs[0];
        this.contents = exprs[1];
        if (this.contents instanceof UnparsedLiteral) {
            this.contents = this.contents.getConvertedExpression(new Class[]{Object.class});
            if (this.contents == null) {
                return false;
            }
        }
        this.lines = exprs[2];
        return true;
    }

    protected Object[] get(Event e) {
        int lines;
        Number[] pages = (Number[])this.pages.getArray(e);
        Number l = (Number)this.lines.getSingle(e);
        if (l == null || (lines = l.intValue()) < 1 || pages.length == 0) {
            return new Object[0];
        }
        Object[] contents = (Object[])this.contents.getAll(e).clone();
        if (contents.length == 0) {
            return new Object[0];
        }
        ArrayList<Object> paginatedList = new ArrayList<Object>();
        for (Number p : pages) {
            int page = p.intValue();
            if (page < 1) continue;
            int max = (page = page > 1 ? (page - 1) * lines : 0) + lines;
            if (max > contents.length) {
                max = contents.length;
            }
            for (int i = page; i < max; ++i) {
                if (contents[i] == null) continue;
                paginatedList.add(contents[i]);
            }
        }
        return paginatedList.toArray();
    }

    public boolean isSingle() {
        return false;
    }

    public Class<?> getReturnType() {
        return Object.class;
    }

    public String toString(Event e, boolean debug) {
        return "page(s) " + this.pages.toString(e, debug) + " of " + this.contents.toString(e, debug) + " with " + this.lines.toString(e, debug) + " lines";
    }

    static {
        Skript.registerExpression(ExprPaginatedList.class, Object.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"page[s] %numbers% of %objects% with %number% lines"});
    }
}

