/*
 * Decompiled with CFR 0.152.
 */
package io.github.apickledwalrus.skriptgui.gui;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptEventHandler;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptEvent;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.Trigger;
import io.github.apickledwalrus.skriptgui.gui.GUIListener;
import io.github.apickledwalrus.skriptgui.gui.TriggerUnregisterListener;
import io.github.apickledwalrus.skriptgui.util.ReflectionUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;

public class SkriptGUIEvent
extends SkriptEvent {
    private static SkriptGUIEvent instance;
    private final Map<Class<?>, List<Trigger>> triggers = (Map)ReflectionUtils.getField(SkriptEventHandler.class, null, "triggers");
    private final List<GUIListener> listeners = new ArrayList<GUIListener>();
    private boolean registered = false;

    public static SkriptGUIEvent getInstance() {
        if (instance == null) {
            instance = new SkriptGUIEvent();
        }
        return instance;
    }

    private SkriptGUIEvent() {
        this.register();
    }

    public boolean check(Event event) {
        ArrayList<GUIListener> current = new ArrayList<GUIListener>(this.listeners);
        for (GUIListener gui : current) {
            gui.onEvent(event);
            if (!(event instanceof Cancellable) || !((Cancellable)event).isCancelled()) continue;
            break;
        }
        return false;
    }

    public void register() {
        if (!this.registered) {
            this.registered = true;
            new TriggerUnregisterListener().register();
            Trigger t = new Trigger(null, "gui inventory click", (SkriptEvent)this, new ArrayList());
            this.addTrigger(t, 0, InventoryClickEvent.class, InventoryDragEvent.class);
            this.addTrigger(t, 1, InventoryCloseEvent.class, InventoryOpenEvent.class);
            ReflectionUtils.invokeMethod(SkriptEventHandler.class, "registerBukkitEvents", null, new Object[0]);
        }
    }

    public void register(GUIListener gui) {
        this.register();
        this.listeners.add(gui);
    }

    public void unregister(GUIListener gui) {
        this.listeners.remove(gui);
    }

    public void unregisterAll() {
        this.listeners.forEach(GUIListener::finalize);
        this.listeners.clear();
        this.registered = false;
    }

    private void addTrigger(Trigger t, int priority, Class<? extends Event> ... classes) {
        if (priority == 0) {
            for (Class<? extends Event> clazz : classes) {
                List<Trigger> current = null;
                try {
                    current = this.triggers.get(clazz);
                }
                catch (NullPointerException ex) {
                    Skript.exception((Throwable)ex, (String[])new String[]{"An error occured while trying to add triggers. If you are unsure why this occured, please report the error on the skript-gui GitHub."});
                }
                ArrayList<Trigger> newList = new ArrayList<Trigger>();
                if (current == null) {
                    newList.add(t);
                    this.triggers.put(clazz, newList);
                    continue;
                }
                newList.addAll(current);
                current.clear();
                current.add(t);
                current.addAll(newList);
            }
        } else {
            SkriptEventHandler.addTrigger((Class[])classes, (Trigger)t);
        }
    }

    public boolean init(Literal<?>[] literals, int i, SkriptParser.ParseResult parseResult) {
        return true;
    }

    public String toString(Event event, boolean b) {
        return event != null ? "gui event: " + event.getEventName() : "gui event";
    }
}

