/*
 * Decompiled with CFR 0.152.
 */
package io.github.apickledwalrus.skriptgui.gui;

import io.github.apickledwalrus.skriptgui.gui.GUI;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.WeakHashMap;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class GUIManager {
    private Map<String, GUI> globalGUIs = new HashMap<String, GUI>();
    private WeakHashMap<Event, GUI> eventGUIs = new WeakHashMap();
    private Map<UUID, GUI> players = new HashMap<UUID, GUI>();

    public GUI getGUIEvent(Event e) {
        return e != null ? this.eventGUIs.get(e) : null;
    }

    public void setGUIEvent(Event e, GUI gui) {
        if (e != null && gui != null) {
            this.eventGUIs.put(e, gui);
        } else if (e != null) {
            this.eventGUIs.remove(e);
        }
    }

    public GUI getGlobalGUI(String id) {
        if (id == null) {
            return null;
        }
        GUI gui = this.globalGUIs.get(id);
        return gui;
    }

    public void addGlobalGUI(String id, GUI gui) {
        if (id != null && gui != null) {
            this.globalGUIs.put(id, gui);
        }
    }

    public GUI removeGlobalGUI(String id) {
        return this.globalGUIs.remove(id);
    }

    public void setGUI(Player p, GUI gui) {
        this.players.put(p.getUniqueId(), gui);
    }

    public void removeGUI(Player p) {
        this.players.remove(p.getUniqueId());
    }

    public boolean hasGUI(Player p) {
        return this.players.containsKey(p.getUniqueId());
    }
}

