/*
 * Decompiled with CFR 0.152.
 */
package io.github.apickledwalrus.skriptgui.gui;

import io.github.apickledwalrus.skriptgui.SkriptGUI;
import io.github.apickledwalrus.skriptgui.gui.SkriptGUIEvent;
import io.github.apickledwalrus.skriptgui.util.InventoryUtils;
import java.util.Iterator;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.plugin.Plugin;

public abstract class GUIListener {
    private Inventory gui;
    private boolean isStarted = false;

    public GUIListener(Inventory gui) {
        this.gui = gui;
    }

    public abstract void onClick(InventoryClickEvent var1, int var2);

    public abstract void onOpen(InventoryOpenEvent var1);

    public abstract void onClose(InventoryCloseEvent var1);

    public abstract void onDrag(InventoryDragEvent var1, int var2);

    public void onEvent(Event event) {
        if (event instanceof InventoryClickEvent && !((InventoryClickEvent)event).isCancelled()) {
            InventoryClickEvent e = (InventoryClickEvent)event;
            if (!this.isAllowedType(e.getClick())) {
                return;
            }
            Inventory clickedInv = e.getClickedInventory();
            if (clickedInv == null) {
                return;
            }
            Inventory oppositeInv = InventoryUtils.getOppositeInventory(e.getView(), clickedInv);
            if (oppositeInv == null || !clickedInv.equals(this.gui) && !oppositeInv.equals(this.gui)) {
                return;
            }
            int slot = e.getSlot();
            switch (e.getAction()) {
                case MOVE_TO_OTHER_INVENTORY: {
                    if (!oppositeInv.equals(this.gui)) break;
                    clickedInv = oppositeInv;
                    slot = InventoryUtils.getSlotTo(oppositeInv, e.getCurrentItem());
                    break;
                }
                case COLLECT_TO_CURSOR: {
                    clickedInv = this.gui;
                    slot = InventoryUtils.getSlotTo(clickedInv, e.getCursor());
                    break;
                }
                case HOTBAR_SWAP: 
                case HOTBAR_MOVE_AND_READD: {
                    if (!this.gui.getType().equals((Object)InventoryType.PLAYER)) break;
                    clickedInv = this.gui;
                    slot = e.getHotbarButton();
                    break;
                }
            }
            if (clickedInv.equals(this.gui)) {
                this.onClick(e, slot);
            }
            return;
        }
        if (event instanceof InventoryOpenEvent) {
            InventoryOpenEvent e = (InventoryOpenEvent)event;
            if (e.getInventory().equals(this.gui)) {
                this.onOpen(e);
            }
            return;
        }
        if (event instanceof InventoryCloseEvent) {
            InventoryCloseEvent e = (InventoryCloseEvent)event;
            if (e.getInventory().equals(this.gui)) {
                if (e.getViewers().size() == 1) {
                    Bukkit.getScheduler().runTaskLater((Plugin)SkriptGUI.getInstance(), this::stop, 1L);
                }
                this.onClose(e);
            }
            return;
        }
        if (event instanceof InventoryDragEvent) {
            InventoryDragEvent e = (InventoryDragEvent)event;
            if (e.getInventory().equals(this.gui)) {
                Iterator iterator = e.getRawSlots().iterator();
                while (iterator.hasNext()) {
                    int slot = (Integer)iterator.next();
                    slot = e.getView().convertSlot(slot);
                    this.onDrag(e, slot);
                    if (!e.isCancelled()) continue;
                    break;
                }
            }
            return;
        }
    }

    public boolean isStarted() {
        return this.isStarted;
    }

    public void stop() {
        if (this.isStarted() && this.gui.getViewers().size() == 0) {
            SkriptGUIEvent.getInstance().unregister(this);
            this.isStarted = false;
        }
    }

    public void start() {
        if (!this.isStarted()) {
            this.isStarted = true;
            SkriptGUIEvent.getInstance().register(this);
        }
    }

    public void setInventory(Inventory inv) {
        this.gui = inv;
    }

    private boolean isAllowedType(ClickType ct) {
        if (ct == null) {
            return false;
        }
        switch (ct) {
            case UNKNOWN: 
            case WINDOW_BORDER_RIGHT: 
            case WINDOW_BORDER_LEFT: 
            case CREATIVE: {
                return false;
            }
        }
        return true;
    }

    public void finalize() {
        this.gui.clear();
    }
}

