/*
 * Decompiled with CFR 0.152.
 */
package io.github.apickledwalrus.skriptgui.elements.sections;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import io.github.apickledwalrus.skriptgui.SkriptGUI;
import io.github.apickledwalrus.skriptgui.elements.sections.SecCreateGUI;
import io.github.apickledwalrus.skriptgui.gui.GUI;
import io.github.apickledwalrus.skriptgui.util.EffectSection;
import io.github.apickledwalrus.skriptgui.util.VariableUtils;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.InventoryCloseEvent;

@Name(value="Close GUI")
@Description(value={"A section that will run when the user closes the GUI. This section is optional."})
@Examples(value={"create a gui with virtual chest inventory with 3 rows named \"My GUI\"", "\trun on gui close:", "\t\tsend \"You just closed this GUI!\" to player"})
@Since(value="1.0.0")
public class SecOnCloseGUI
extends EffectSection {
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        if (this.checkIfCondition()) {
            return false;
        }
        if (!SecOnCloseGUI.isCurrentSection(SecCreateGUI.class)) {
            Skript.error((String)"GUI close sections can only be put within GUI creation or editing sections.");
            return false;
        }
        if (!this.hasSection()) {
            Skript.error((String)"A GUI close section is pointless without any content! Make sure you put some.");
            return false;
        }
        this.loadSection("gui close", false, InventoryCloseEvent.class);
        return true;
    }

    @Override
    public void execute(Event e) {
        GUI gui;
        if (this.hasSection() && (gui = SkriptGUI.getGUIManager().getGUIEvent(e)) != null) {
            Object vars = VariableUtils.getInstance().copyVariables(e);
            gui.setOnClose(event -> {
                VariableUtils.getInstance().pasteVariables((Event)event, vars);
                this.runSection((Event)event);
            });
        }
    }

    public String toString(Event e, boolean debug) {
        return "run on gui close";
    }

    static {
        Skript.registerCondition(SecOnCloseGUI.class, (String[])new String[]{"run (when|while) clos(e|ing) [[the] gui]", "run (when|while) [the] gui closes", "run on gui clos(e|ing)"});
    }
}

