/*
 * Decompiled with CFR 0.152.
 */
package io.github.apickledwalrus.skriptgui.elements.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import io.github.apickledwalrus.skriptgui.gui.GUI;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Open GUI")
@Description(value={"Opens the given GUI for the given players."})
@Examples(value={"create a gui with virtual chest inventory named \"My GUI Name\" with 3 rows", "open gui last gui for player"})
@Since(value="1.0.0")
public class EffOpenGUI
extends Effect {
    private Expression<GUI> gui;
    private Expression<Player> players;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.gui = exprs[0];
        this.players = exprs[1];
        return true;
    }

    protected void execute(Event e) {
        GUI gui = (GUI)this.gui.getSingle(e);
        if (gui != null) {
            for (Player p : (Player[])this.players.getArray(e)) {
                p.openInventory(gui.getInventory());
            }
        }
    }

    public String toString(@Nullable Event e, boolean debug) {
        return "open gui " + this.gui.toString(e, debug) + " to " + this.players.toString(e, debug);
    }

    static {
        Skript.registerEffect(EffOpenGUI.class, (String[])new String[]{"(open|show) [[skript[-]]gui] %guiinventory% (to|for) %players%"});
    }
}

