/*
 * Decompiled with CFR 0.152.
 */
package io.github.apickledwalrus.skriptgui.elements.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import io.github.apickledwalrus.skriptgui.util.InventoryUtils;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;

@Name(value="Virtual Inventory")
@Description(value={"An expression to create inventories that can be used with GUIs."})
@Examples(value={"create a gui with virtual chest inventory with 3 rows named \"My GUI\""})
@Since(value="1.0.0")
public class ExprVirtualInventory
extends SimpleExpression<Inventory> {
    private Expression<InventoryType> inventoryType;
    private Expression<Number> size;
    private Expression<String> name;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.inventoryType = exprs[0];
        if (matchedPattern > 1) {
            this.name = exprs[1];
            this.size = exprs[2];
        } else {
            this.name = exprs[2];
            this.size = exprs[1];
        }
        return true;
    }

    protected Inventory[] get(Event e) {
        InventoryType type = (InventoryType)this.inventoryType.getSingle(e);
        if (type == null) {
            return new Inventory[0];
        }
        Number size = this.size != null ? (Number)((Number)this.size.getSingle(e)) : (Number)null;
        String name = this.name != null ? (String)this.name.getSingle(e) : null;
        return new Inventory[]{InventoryUtils.newInventory(type, size != null ? size.intValue() : 0, name)};
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends Inventory> getReturnType() {
        return Inventory.class;
    }

    public String toString(Event e, boolean debug) {
        return "virtual " + this.inventoryType.toString(e, debug) + (this.name != null ? " with name" + this.name.toString(e, debug) : "") + (this.size != null ? " with " + this.size.toString(e, debug) + " rows" : "");
    }

    static {
        Skript.registerExpression(ExprVirtualInventory.class, Inventory.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"virtual %inventorytype% [with size %-number%] [(named|with (name|title)) %-string%]", "virtual %inventorytype% [with %-number% row[s]] [(named|with (name|title)) %-string%]", "virtual %inventorytype% [(named|with (name|title)) %-string%] with size %-number%", "virtual %inventorytype% [(named|with (name|title)) %-string%] with %-number% row[s]"});
    }
}

