/*
 * Decompiled with CFR 0.152.
 */
package io.github.apickledwalrus.skriptgui.elements.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import io.github.apickledwalrus.skriptgui.SkriptGUI;
import io.github.apickledwalrus.skriptgui.gui.GUI;
import org.bukkit.event.Event;

@Name(value="Last GUI/GUI from id")
@Description(value={"It is used to return the last created gui or a gui from a string id."})
@Examples(value={"open gui last gui for player", "open gui (gui with id \"globalGUI\") for player"})
@Since(value="1.0.0")
public class ExprLastGUI
extends SimpleExpression<GUI> {
    private Expression<String> id;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        if (matchedPattern == 1) {
            this.id = exprs[0];
        }
        return true;
    }

    protected GUI[] get(Event e) {
        if (this.id != null) {
            return new GUI[]{SkriptGUI.getGUIManager().getGlobalGUI((String)this.id.getSingle(e))};
        }
        return new GUI[]{SkriptGUI.getGUIManager().getGUIEvent(e)};
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.DELETE && this.id != null) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Object.class});
        }
        return null;
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        GUI gui;
        String id = (String)this.id.getSingle(e);
        if (id != null && (gui = SkriptGUI.getGUIManager().removeGlobalGUI(id)) != null) {
            gui.clear();
        }
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends GUI> getReturnType() {
        return GUI.class;
    }

    public String toString(Event e, boolean debug) {
        return this.id == null ? "last gui" : "gui with id" + this.id.toString(e, debug);
    }

    static {
        Skript.registerExpression(ExprLastGUI.class, GUI.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"[the] last[ly] [created] gui", "[the] gui [with [the] id] %string%"});
    }
}

