/*
 * Decompiled with CFR 0.152.
 */
package io.github.apickledwalrus.skriptgui.elements.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import io.github.apickledwalrus.skriptgui.SkriptGUI;
import io.github.apickledwalrus.skriptgui.elements.sections.SecCreateGUI;
import io.github.apickledwalrus.skriptgui.gui.GUI;
import io.github.apickledwalrus.skriptgui.util.EffectSection;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="GUI Properties")
@Description(value={"Different properties of the GUI. They can be modified."})
@Examples(value={"edit gui last gui:", "\tset the gui-inventory-name to \"New GUI Name!\"", "\tset the gui-size to 3 # Sets the number of rows to 3 (if possible)", "\tset the gui-shape to \"xxxxxxxxx\", \"x-------x\", and \"xxxxxxxxx\"", "\tset the gui-lock-status to false # Players can take items from this GUI now"})
@Since(value="1.0.0")
public class ExprGUIProperties
extends SimpleExpression<Object> {
    private int pattern;
    private GUI.ShapeMode shapeMode;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        if (!EffectSection.isCurrentSection(SecCreateGUI.class)) {
            Skript.error((String)"You can't change or get the GUI properties outside of a GUI creation or editing section.");
            return false;
        }
        this.pattern = matchedPattern;
        this.shapeMode = parseResult.mark == 1 ? GUI.ShapeMode.ITEMS : (parseResult.mark == 2 ? GUI.ShapeMode.ACTIONS : GUI.ShapeMode.BOTH);
        return true;
    }

    @Nullable
    protected Object[] get(Event e) {
        GUI gui = SkriptGUI.getGUIManager().getGUIEvent(e);
        if (gui != null) {
            switch (this.pattern) {
                case 0: {
                    return new String[]{gui.getName()};
                }
                case 1: {
                    return new Number[]{gui.getInventory().getSize()};
                }
                case 2: {
                    return new String[]{gui.getRawShape()};
                }
                case 3: {
                    return new Boolean[]{!gui.getStealable()};
                }
            }
        }
        return new Object[0];
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.RESET) {
            switch (this.pattern) {
                case 0: {
                    return (Class[])CollectionUtils.array((Object[])new Class[]{String.class});
                }
                case 1: {
                    return (Class[])CollectionUtils.array((Object[])new Class[]{Number.class});
                }
                case 2: {
                    return (Class[])CollectionUtils.array((Object[])new Class[]{String[].class});
                }
                case 3: {
                    return (Class[])CollectionUtils.array((Object[])new Class[]{Boolean.class});
                }
            }
        }
        return null;
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        if (delta == null || mode != Changer.ChangeMode.SET && mode != Changer.ChangeMode.RESET) {
            return;
        }
        GUI gui = SkriptGUI.getGUIManager().getGUIEvent(e);
        block0 : switch (mode) {
            case SET: {
                switch (this.pattern) {
                    case 0: {
                        gui.setName((String)delta[0]);
                        break;
                    }
                    case 1: {
                        gui.setSize(((Number)delta[0]).intValue());
                        break;
                    }
                    case 2: {
                        gui.setShape(false, this.shapeMode, (String[])delta[0]);
                        break;
                    }
                    case 3: {
                        gui.setStealable((Boolean)delta[0] == false);
                    }
                }
                break;
            }
            case RESET: {
                switch (this.pattern) {
                    case 0: {
                        gui.setName(gui.getInventory().getType().getDefaultTitle());
                        break block0;
                    }
                    case 1: {
                        gui.setSize(gui.getInventory().getType().getDefaultSize());
                        break block0;
                    }
                    case 2: {
                        gui.setShape(true, null, new String[0]);
                        break block0;
                    }
                    case 3: {
                        gui.setStealable(false);
                    }
                }
            }
        }
    }

    public boolean isSingle() {
        return false;
    }

    public Class<? extends Object> getReturnType() {
        switch (this.pattern) {
            case 0: {
                return String.class;
            }
            case 1: {
                return Number.class;
            }
            case 2: {
                return String.class;
            }
            case 3: {
                return Boolean.class;
            }
        }
        return Object.class;
    }

    public String toString(Event e, boolean debug) {
        switch (this.pattern) {
            case 0: {
                return "the gui inventory name";
            }
            case 1: {
                return "the total number of gui rows";
            }
            case 2: {
                return "the gui shape of " + this.shapeMode.name().toLowerCase();
            }
            case 3: {
                return "the gui lock status";
            }
        }
        return "gui properties";
    }

    static {
        Skript.registerExpression(ExprGUIProperties.class, Object.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"[the] gui(-| )[inventory(-| )]name", "[the] [total] [(number|amount) of] gui(-| )(size|rows)", "[the] gui(-| )shape [of (1\u00a6items|2\u00a6actions)]", "[the] gui(-| )lock(-| )status"});
    }
}

