/*
 * Decompiled with CFR 0.152.
 */
package com.olyno.skester.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.olyno.skester.util.effects.AssertEffect;
import org.bukkit.event.Event;

@Name(value="Assert Equals")
@Description(value={"Checks if a value is equal to another. Fails if it is not."})
@Examples(value={"command checkConsole:\n\ttrigger:\n\t\tit \"should be equal\":\n\t\t\tassert equals sender to console with message \"This sender is not the console!\""})
@Since(value="1.0.0")
public class EffAssertEquals
extends AssertEffect {
    private Expression<Object> firstValue;
    private Expression<Object> secondValue;
    private Expression<String> message;
    private boolean isNegated;

    public boolean init(Expression<?>[] expr, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.firstValue = expr[0];
        this.secondValue = expr[1];
        this.message = expr[2];
        this.isNegated = matchedPattern == 1;
        return true;
    }

    protected void execute(Event e) {
        if (this.isAvailable().booleanValue()) {
            String msg;
            String string = msg = this.message != null ? (String)this.message.getSingle(e) : "";
            if (this.isNegated) {
                if (!msg.isEmpty()) {
                    this.latestTest.assertNotEquals(this.firstValue.getSingle(e), this.secondValue.getSingle(e), msg);
                } else {
                    this.latestTest.assertNotEquals(this.firstValue.getSingle(e), this.secondValue.getSingle(e));
                }
            } else if (!msg.isEmpty()) {
                this.latestTest.assertEquals(this.firstValue.getSingle(e), this.secondValue.getSingle(e), msg);
            } else {
                this.latestTest.assertEquals(this.firstValue.getSingle(e), this.secondValue.getSingle(e));
            }
        }
    }

    public String toString(Event e, boolean debug) {
        return "assert" + (this.isNegated ? " not" : "") + " equals " + this.firstValue.toString(e, debug) + " to " + this.secondValue.toString(e, debug) + (this.message != null ? " with message " + this.message.toString(e, debug) : "");
    }

    static {
        Skript.registerEffect(EffAssertEquals.class, (String[])new String[]{"assert [is] equal[s] %object% to %object% [with [[error] message] %-string%]", "assert [is] not equal[s] %object% to %object% [with [[error] message] %-string%]"});
    }
}

