/*
 * Decompiled with CFR 0.152.
 */
package uk.tim740.skUtilities;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import uk.tim740.skUtilities.skUtilities;

public class UpdateChecker
implements Runnable {
    private static final String UPDATE_URL = "https://raw.githubusercontent.com/tim740/skUtilities/master/latest.ver";
    private static final String RELEASES_URL = "https://github.com/tim740/skUtilities/releases/";
    private static final String DOWNLOAD_URL = "https://github.com/tim740/skUtilities/releases/download/v";
    private static final String LATEST_RELEASE = "https://github.com/tim740/skUtilities/releases/latest";
    private final skUtilities plugin;
    private final boolean broadcastUpdates;
    private final boolean downloadUpdates;
    private final boolean downloadChangelog;

    UpdateChecker(skUtilities plugin, boolean broadcast, boolean downloadUpdates, boolean downloadChangelog) {
        this.plugin = plugin;
        this.broadcastUpdates = broadcast;
        this.downloadUpdates = downloadUpdates;
        this.downloadChangelog = downloadChangelog;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        System.out.print("broadcast " + this.broadcastUpdates);
        System.out.print("downloadUpdates" + this.downloadUpdates);
        System.out.print("downloadChangelog" + this.downloadChangelog);
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(new URL(UPDATE_URL).openStream()));
                try {
                    String remoteVersion = reader.readLine();
                    if (Objects.equals(this.plugin.getDescription().getVersion(), remoteVersion)) {
                        return;
                    }
                    skUtilities.prSysI("A new version of v" + remoteVersion + " is out.");
                    String versionUrlPrefix = DOWNLOAD_URL + remoteVersion + '/';
                    if (Objects.equals(this.downloadUpdates, true)) {
                        if (!new File(String.valueOf(this.plugin.getDataFolder().toPath().resolve(String.valueOf(this.buildFilePrefix(remoteVersion, '.')) + ".jar"))).exists()) {
                            this.downloadUpdate(versionUrlPrefix, this.buildFilePrefix(remoteVersion, '.'));
                        }
                    } else {
                        this.prSysU("Download v" + remoteVersion + ": " + LATEST_RELEASE);
                        skUtilities.prSysI("Option: 'downloadUpdates' is disabled in the config.");
                    }
                    if (Objects.equals(this.downloadChangelog, true)) {
                        if (new File(String.valueOf(this.plugin.getDataFolder().toPath().resolve(String.valueOf(this.buildFilePrefix(remoteVersion, '_')) + "_Changelog.sk"))).exists()) return;
                        this.downloadChangelog(versionUrlPrefix, this.buildFilePrefix(remoteVersion, '_'));
                        return;
                    }
                    skUtilities.prSysI("View changelog here: https://github.com/tim740/skUtilities/releases/latest");
                    return;
                }
                finally {
                    if (reader == null) return;
                    reader.close();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (Exception e) {
            skUtilities.prSysE("Failed to get latest version number!", "Main", e);
        }
    }

    private void downloadUpdate(String urlPrefix, String filePrefix) {
        String pluginFileName = String.valueOf(filePrefix) + ".jar";
        Path pluginJar = this.plugin.getDataFolder().toPath().resolve(pluginFileName);
        if (Files.notExists(pluginJar, new LinkOption[0])) {
            skUtilities.prSysI("Starting download of " + pluginJar);
            skUtilities.downloadFile(pluginJar, String.valueOf(urlPrefix) + pluginFileName);
            skUtilities.prSysI("Finished download of " + pluginJar);
        }
    }

    private void downloadChangelog(String urlPrefix, String filePrefix) {
        String changelogFileName = String.valueOf(filePrefix) + "_Changelog.sk";
        Path changelogFile = this.plugin.getDataFolder().toPath().resolve(changelogFileName);
        if (Files.notExists(changelogFile, new LinkOption[0])) {
            skUtilities.downloadFile(changelogFile, String.valueOf(urlPrefix) + changelogFileName);
        }
        skUtilities.prSysI("View changelog for '" + changelogFile);
    }

    private String buildFilePrefix(String remoteVersion, char versionSeparator) {
        return String.valueOf(this.plugin.getName()) + versionSeparator + 'v' + remoteVersion;
    }

    private void prSysU(String s) {
        if (this.broadcastUpdates) {
            String message = ChatColor.AQUA + "[" + this.plugin.getName() + ": Update] " + ChatColor.GRAY + s;
            Bukkit.broadcast((String)message, (String)(String.valueOf(this.plugin.getName()) + ".update"));
        }
        skUtilities.prSysI(s);
    }
}

