/*
 * Decompiled with CFR 0.152.
 */
package uk.tim740.skUtilities;

import ch.njol.skript.Skript;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.DecimalFormat;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import uk.tim740.skUtilities.MetricsLite;
import uk.tim740.skUtilities.Reg;
import uk.tim740.skUtilities.util.EffReloadConfig;

public class skUtilities
extends JavaPlugin {
    public void onEnable() {
        long s = System.currentTimeMillis();
        Skript.registerAddon((JavaPlugin)this);
        this.getDataFolder().mkdirs();
        this.saveDefaultConfig();
        if (this.getConfig().getInt("configVersion") != 9 || !this.getConfig().isSet("configVersion")) {
            try {
                Path pth = Paths.get(String.valueOf(this.getDataFolder().getAbsolutePath()) + File.separator + "config.yml", new String[0]);
                Path ptho = Paths.get(String.valueOf(this.getDataFolder().getAbsolutePath()) + File.separator + "config.old", new String[0]);
                if (Files.exists(ptho, new LinkOption[0])) {
                    Files.delete(ptho);
                }
                pth.toFile().renameTo(ptho.toFile());
                this.saveDefaultConfig();
                skUtilities.prSysI("");
                skUtilities.prSysI("You where using an old version of the config!");
                skUtilities.prSysI("It was copied and renamed to 'config.old'");
                skUtilities.prSysI("A new config has been generated!");
                skUtilities.prSysI("New config has reset to default options!");
                skUtilities.prSysI("");
            }
            catch (Exception x) {
                skUtilities.prSysE(x.getMessage(), ((Object)((Object)this)).getClass().getSimpleName(), x);
            }
        }
        String ls = "";
        if (this.getConfig().getBoolean("loadConversions", true)) {
            ls = String.valueOf(ls) + "Conversions,";
        }
        Reg.convert();
        if (this.getConfig().getBoolean("loadFiles", true)) {
            ls = String.valueOf(ls) + " Files,";
        }
        Reg.files();
        if (this.getConfig().getBoolean("loadYaml", true)) {
            ls = String.valueOf(ls) + " Yaml,";
        }
        Reg.yaml();
        if (this.getConfig().getBoolean("loadUrls", true)) {
            ls = String.valueOf(ls) + " Urls,";
        }
        Reg.url();
        if (this.getConfig().getBoolean("loadUtilities", true)) {
            ls = String.valueOf(ls) + " Utilities";
        }
        Reg.utils();
        Skript.registerEffect(EffReloadConfig.class, (String[])new String[]{"reload %string%'s config", "reload config of %string%"});
        if (this.getConfig().getBoolean("checkForUpdates", true)) {
            Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this, this::updateChk, 1L, 864000L);
        } else {
            skUtilities.prSysI("Checking for updates is disabled, you should consider enabling it again!");
        }
        try {
            MetricsLite mcs = new MetricsLite((Plugin)this);
            mcs.start();
        }
        catch (Exception x) {
            skUtilities.prSysE("Failed to submit stats to Metrics, MCStats could be down!", ((Object)((Object)this)).getClass().getSimpleName(), x);
        }
        skUtilities.prSysI("loaded modules (" + ls + ") in " + (System.currentTimeMillis() - s) + "ms");
    }

    private void updateChk() {
        skUtilities.prSysI("Checking for update now you will be notified if there is an update!");
        try {
            BufferedReader ur = new BufferedReader(new InputStreamReader(new URL("https://raw.githubusercontent.com/tim740/skUtilities/master/latest.ver").openStream()));
            String v = ur.readLine();
            ur.close();
            if (!Objects.equals(skUtilities.getVer(), v)) {
                skUtilities.prSysI("A new version of the skUtilities is out v" + v);
                if (this.getConfig().getBoolean("downloadUpdates", true)) {
                    String dln = "plugins" + File.separator + "skUtilities" + File.separator + "skUtilities.v" + v + ".jar";
                    if (!new File(dln).exists()) {
                        skUtilities.prSysI("Starting download of skUtilities v" + v);
                        skUtilities.downloadFile(Paths.get(dln, new String[0]), "https://github.com/tim740/skUtilities/releases/download/v" + v + "/skUtilities.v" + v + ".jar");
                        skUtilities.prSysI("Finished download of 'skUtilities v" + v + "' located in 'plugins/skUtilities'");
                        if (this.getConfig().getBoolean("downloadChangelog", true)) {
                            skUtilities.downloadFile(Paths.get("plugins" + File.separator + "skUtilities" + File.separator + "skUtilities_v" + v + "_Changelog.sk", new String[0]), "https://github.com/tim740/skUtilities/releases/download/v" + v + "/skUtilities_v" + v + "_Changelog.sk");
                            skUtilities.prSysI("Finished download of 'skUtilities_v" + v + "_Changelog.sk' located in 'plugins/skUtilities'");
                        } else {
                            skUtilities.prSysI("View changelog here: 'https://github.com/tim740/skUtilities/releases/latest'");
                        }
                    } else {
                        skUtilities.prSysI("Latest version of skUtilities (v" + v + ") is already downloaded and ready to use!");
                        this.prSysU("Latest version of skUtilities (v" + v + ") is already downloaded and ready to use!");
                    }
                } else {
                    skUtilities.prSysI("Download latest version here: 'https://github.com/tim740/skUtilities/releases/latest'");
                    skUtilities.prSysI("You should consider enabling `downloadUpdates` in the config.");
                    this.prSysU("Download latest version here: 'https://github.com/tim740/skUtilities/releases/latest'");
                }
            } else {
                skUtilities.prSysI("Currently using the latest version of skUtilities.");
            }
        }
        catch (Exception e) {
            skUtilities.prSysE("Failed to get latest version number, you might be offline!", "Main", e);
        }
    }

    private void prSysU(String s) {
        if (Bukkit.getPluginManager().getPlugin("skUtilities").getConfig().getBoolean("broadcastUpdates", true)) {
            Bukkit.broadcast((String)(ChatColor.AQUA + "[skUtilities: Update] " + ChatColor.GRAY + s), (String)"skUtilities.update");
        }
    }

    public static void prSysE(String s, String c) {
        Bukkit.getServer().getLogger().severe("[skUtilities] v" + skUtilities.getVer() + ": " + s + " (" + c + ".class)");
        if (Bukkit.getPluginManager().getPlugin("skUtilities").getConfig().getBoolean("broadcastErrors", true)) {
            Bukkit.broadcast((String)(ChatColor.RED + "[skUtilities: ERROR]" + ChatColor.GRAY + " v" + skUtilities.getVer() + ": " + s + " (" + c + ".class)"), (String)"skUtilities.error");
        }
    }

    public static void prSysE(String s, String c, Exception e) {
        if (Bukkit.getPluginManager().getPlugin("skUtilities").getConfig().getBoolean("debug", true)) {
            e.printStackTrace();
        } else {
            skUtilities.prSysE(s, c);
        }
    }

    public static void prSysI(String s) {
        Bukkit.getServer().getLogger().info("[skUtilities] v" + skUtilities.getVer() + ": " + s);
    }

    private static String getVer() {
        return Bukkit.getPluginManager().getPlugin("skUtilities").getDescription().getVersion();
    }

    public static String getFileSize(double i) {
        DecimalFormat df = new DecimalFormat("#.##");
        if (i < 1024.0) {
            return (String.valueOf(i) + " B").replaceFirst(".0", "");
        }
        if (i < 1048576.0) {
            return String.valueOf(df.format(i / 1024.0)) + " KB";
        }
        if (i < 1.073741824E9) {
            return String.valueOf(df.format(i / 1048576.0)) + " MB";
        }
        if (i < 1.099511627776E12) {
            return String.valueOf(df.format(i / 1.073741824E9)) + " GB";
        }
        return String.valueOf(df.format(i / 1.099511627776E12)) + " TB";
    }

    public static void downloadFile(Path pth, String url) {
        try {
            Files.copy(new URL(url).openStream(), pth, new CopyOption[0]);
        }
        catch (Exception x) {
            skUtilities.prSysE("Error downloading from: '" + url + "' Is the site down?", "Utils", x);
        }
    }

    public static String getDefaultPath(String pth) {
        if (!Bukkit.getPluginManager().getPlugin("skUtilities").getConfig().getBoolean("useRootAsDefaultPath", false)) {
            String dp = Paths.get("", new String[0]).normalize().toAbsolutePath().toString();
            if (pth.contains(dp)) {
                return String.valueOf(pth) + File.separator;
            }
            return String.valueOf(dp) + File.separator + pth;
        }
        return pth;
    }
}

