/*
 * Decompiled with CFR 0.152.
 */
package uk.tim740.skUtilities;

import ch.njol.skript.Skript;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.DecimalFormat;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import uk.tim740.skUtilities.MetricsLite;
import uk.tim740.skUtilities.RegConvert;
import uk.tim740.skUtilities.RegFiles;
import uk.tim740.skUtilities.RegUrl;
import uk.tim740.skUtilities.RegUtil;
import uk.tim740.skUtilities.config.EffReloadConfig;

public class skUtilities
extends JavaPlugin {
    public void onEnable() {
        long s = System.currentTimeMillis();
        Skript.registerAddon((JavaPlugin)this);
        this.getDataFolder().mkdirs();
        this.saveDefaultConfig();
        if (this.getConfig().getInt("configVersion") != 7 || !this.getConfig().isSet("configVersion")) {
            File pth = new File(String.valueOf(this.getDataFolder().getAbsolutePath()) + File.separator + "config.yml");
            File ptho = new File(String.valueOf(this.getDataFolder().getAbsolutePath()) + File.separator + "config.old");
            if (ptho.exists()) {
                ptho.delete();
            }
            pth.renameTo(ptho);
            this.saveDefaultConfig();
            skUtilities.prSysI("");
            skUtilities.prSysI("You where using an old version of the config!");
            skUtilities.prSysI("It was copied and renamed to 'config.old'");
            skUtilities.prSysI("A new config has been generated!");
            skUtilities.prSysI("New config has reset to default options!");
            skUtilities.prSysI("");
        }
        if (this.getConfig().getBoolean("loadConversions", true)) {
            RegConvert.reg();
        }
        if (this.getConfig().getBoolean("loadFiles", true)) {
            RegFiles.reg();
        }
        if (this.getConfig().getBoolean("loadUrls", true)) {
            RegUrl.reg();
        }
        if (this.getConfig().getBoolean("loadUtilities", true)) {
            RegUtil.reg();
        }
        Skript.registerEffect(EffReloadConfig.class, (String[])new String[]{"reload %string%'s config", "reload config of %string%"});
        if (this.getConfig().getBoolean("checkForUpdates", true)) {
            Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this, this::updateChk, 1L, 864000L);
        } else {
            skUtilities.prSysI("Checking for updates is disabled, you should consider enabling it again!");
        }
        try {
            MetricsLite mcs = new MetricsLite((Plugin)this);
            mcs.start();
        }
        catch (Exception e) {
            skUtilities.prSysE("Failed to submit stats to Metrics, MCStats could be down!", ((Object)((Object)this)).getClass().getSimpleName(), e);
        }
        skUtilities.prSysI("Has fully loaded in " + (System.currentTimeMillis() - s) + "ms!");
    }

    private void updateChk() {
        skUtilities.prSysI("Checking for update now you will be notified if there is an update!");
        try {
            BufferedReader ur = new BufferedReader(new InputStreamReader(new URL("https://raw.githubusercontent.com/tim740/skUtilities/master/latest.ver").openStream()));
            String v = ur.readLine();
            ur.close();
            if (!Objects.equals(skUtilities.getVer(), v)) {
                skUtilities.prSysI("A new version of the skUtilities is out v" + v);
                if (this.getConfig().getBoolean("downloadUpdates", true)) {
                    String dln = "plugins" + File.separator + "skUtilities" + File.separator + "skUtilities.v" + v + ".jar";
                    if (!new File(dln).exists()) {
                        skUtilities.prSysI("Starting download of skUtilities v" + v);
                        skUtilities.downloadFile(Paths.get(dln, new String[0]), "https://github.com/tim740/skUtilities/releases/download/v" + v + "/skUtilities.v" + v + ".jar");
                        skUtilities.prSysI("Finished download of 'skUtilities v" + v + "' located in 'plugins/skUtilities'");
                        if (this.getConfig().getBoolean("downloadChangelog", true)) {
                            skUtilities.downloadFile(Paths.get("plugins" + File.separator + "skUtilities" + File.separator + "skUtilities_v" + v + "_Changelog.sk", new String[0]), "https://github.com/tim740/skUtilities/releases/download/v" + v + "/skUtilities_v" + v + "_Changelog.sk");
                            skUtilities.prSysI("Finished download of 'skUtilities_v" + v + "_Changelog.sk' located in 'plugins/skUtilities'");
                        } else {
                            skUtilities.prSysI("View changelog here: 'https://github.com/tim740/skUtilities/releases/latest'");
                        }
                    } else {
                        skUtilities.prSysI("Latest version of skUtilities (v" + v + ") is already downloaded and ready to use!");
                        Bukkit.broadcast((String)(ChatColor.AQUA + "[skUtilities: Update] " + ChatColor.GRAY + "Latest version of skUtilities (v" + v + ") is already downloaded and ready to use!"), (String)"skUtilities.update");
                    }
                } else {
                    skUtilities.prSysI("Download latest version here: 'https://github.com/tim740/skUtilities/releases/latest'");
                    skUtilities.prSysI("You should consider enabling `downloadUpdates` in the config.");
                    Bukkit.broadcast((String)(ChatColor.AQUA + "[skUtilities: Update] " + ChatColor.GRAY + "You can find the latest version here: 'https://github.com/tim740/skUtilities/releases/latest'"), (String)"skUtilities.update");
                }
            } else {
                skUtilities.prSysI("Currently using the latest version of skUtilities.");
            }
        }
        catch (Exception e) {
            skUtilities.prSysE("Failed to get latest version number, you might be offline!", "Main", e);
        }
    }

    public static void prSysE(String s, String c) {
        Bukkit.getServer().getLogger().severe("[skUtilities] v" + skUtilities.getVer() + ": " + s + " (" + c + ".class)");
        Bukkit.broadcast((String)(ChatColor.RED + "[skUtilities: ERROR]" + ChatColor.GRAY + " v" + skUtilities.getVer() + ": " + s + " (" + c + ".class)"), (String)"skUtilities.error");
    }

    public static void prSysE(String s, String c, Exception e) {
        if (Bukkit.getPluginManager().getPlugin("skUtilities").getConfig().getBoolean("debug", true)) {
            e.printStackTrace();
        } else {
            skUtilities.prSysE(s, c);
        }
    }

    public static void prSysI(String s) {
        Bukkit.getServer().getLogger().info("[skUtilities] v" + skUtilities.getVer() + ": " + s);
    }

    private static String getVer() {
        return Bukkit.getPluginManager().getPlugin("skUtilities").getDescription().getVersion();
    }

    public static String getFileSize(double s) {
        DecimalFormat df = new DecimalFormat("#.##");
        if (s < 1024.0) {
            return (String.valueOf(s) + " B").replaceFirst(".0", "");
        }
        if (s < 1048576.0) {
            return String.valueOf(df.format(s / 1024.0)) + " KB";
        }
        if (s < 1.073741824E9) {
            return String.valueOf(df.format(s / 1048576.0)) + " MB";
        }
        if (s < 1.099511627776E12) {
            return String.valueOf(df.format(s / 1.073741824E9)) + " GB";
        }
        return String.valueOf(df.format(s / 1.099511627776E12)) + " TB";
    }

    public static void downloadFile(Path pth, String url) {
        try {
            Files.copy(new URL(url).openStream(), pth, new CopyOption[0]);
        }
        catch (MalformedURLException x) {
            skUtilities.prSysE("Error downloading from: '" + url + "' Is the site down?", "Utils", x);
        }
        catch (IOException x) {
            skUtilities.prSysE(x.getMessage(), "Utils", x);
        }
    }

    public static String getDefaultPath(String pth) {
        if (!Bukkit.getPluginManager().getPlugin("skUtilities").getConfig().getBoolean("useRootAsDefaultPath", false)) {
            String dp = Paths.get("", new String[0]).normalize().toAbsolutePath().toString();
            if (pth.contains(dp)) {
                return String.valueOf(pth) + File.separator;
            }
            return String.valueOf(dp) + File.separator + pth;
        }
        return pth;
    }
}

