/*
 * Decompiled with CFR 0.152.
 */
package uk.tim740.skUtilities;

import java.io.File;
import java.io.FileOutputStream;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Paths;
import java.text.DecimalFormat;
import org.bukkit.Bukkit;
import uk.tim740.skUtilities.skUtilities;

public class Utils {
    public static String getFileSize(double s) {
        DecimalFormat df = new DecimalFormat("#.##");
        if (s < 1024.0) {
            return (String.valueOf(s) + " B").replaceFirst(".0", "");
        }
        if (s < 1048576.0) {
            return String.valueOf(df.format(s / 1024.0)) + " KB";
        }
        if (s < 1.073741824E9) {
            return String.valueOf(df.format(s / 1048576.0)) + " MB";
        }
        if (s < 1.099511627776E12) {
            return String.valueOf(df.format(s / 1.073741824E9)) + " GB";
        }
        return String.valueOf(df.format(s / 1.099511627776E12)) + " TB";
    }

    public static void downloadFile(File pth, String url) {
        try {
            ReadableByteChannel rbc = Channels.newChannel(new URL(url).openStream());
            FileOutputStream fos = new FileOutputStream(pth);
            fos.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
            fos.close();
            rbc.close();
        }
        catch (Exception e) {
            skUtilities.prSys(e.getMessage(), "Utils", 0);
        }
    }

    public static String getDefaultPath(String pth) {
        if (Bukkit.getPluginManager().getPlugin("skUtilities").getConfig().getBoolean("useRootAsDefaultPath", true)) {
            String dp = Paths.get("", new String[0]).normalize().toAbsolutePath().toString();
            if (pth.contains(dp)) {
                return String.valueOf(pth) + File.separator;
            }
            return String.valueOf(dp) + File.separator + pth;
        }
        return pth;
    }
}

