/*
 * Decompiled with CFR 0.152.
 */
package uk.tim740.skUtilities;

import ch.njol.skript.Skript;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import uk.tim740.skUtilities.Metrics;
import uk.tim740.skUtilities.RegConfig;
import uk.tim740.skUtilities.RegConvert;
import uk.tim740.skUtilities.RegFiles;
import uk.tim740.skUtilities.RegUtil;
import uk.tim740.skUtilities.Utils;

public class skUtilities
extends JavaPlugin {
    public void onEnable() {
        long s = System.currentTimeMillis();
        Skript.registerAddon((JavaPlugin)this);
        this.getDataFolder().mkdirs();
        this.saveDefaultConfig();
        if (this.getConfig().getInt("configVersion") != 3) {
            this.resetConfig();
        } else if (!this.getConfig().contains("configVersion")) {
            this.resetConfig();
        }
        if (this.getConfig().getBoolean("loadConversions", true)) {
            RegConvert.regC();
        }
        if (this.getConfig().getBoolean("loadUtilities", true)) {
            RegUtil.regU();
        }
        if (this.getConfig().getBoolean("loadFiles", true)) {
            RegFiles.regF();
        }
        RegConfig.regCo();
        if (this.getConfig().getBoolean("checkForUpdates", true)) {
            Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this, this::updateChk, 1L, 864000L);
        } else {
            skUtilities.prSysi("It seems like you've disabled updates, you should consider enabling them again!");
        }
        try {
            Metrics metrics = new Metrics((Plugin)this);
            metrics.start();
        }
        catch (Exception exception) {
            skUtilities.prSys("Failed to submit stats to Metrics", ((Object)((Object)this)).getClass().getSimpleName(), 0);
        }
        skUtilities.prSysi("Has fully loaded in " + (System.currentTimeMillis() - s) + "ms!");
    }

    public static void prSys(String s, String c, Integer t) {
        if (t == 0) {
            Bukkit.getServer().getLogger().severe("[skUtilities] v" + skUtilities.getVer() + ": " + s + " (" + c + ".class)");
            Bukkit.broadcast((String)(ChatColor.RED + "[skUtilities: ERROR]" + ChatColor.GRAY + " v" + skUtilities.getVer() + ": " + s + " (" + c + ".class)"), (String)"skUtilities.error");
        } else if (t == 1) {
            Bukkit.getServer().getLogger().warning("[skUtilities] v" + skUtilities.getVer() + ": " + s + " (" + c + ".class)");
            Bukkit.broadcast((String)(ChatColor.GOLD + "[skUtilities: WARNING]" + ChatColor.GRAY + " v" + skUtilities.getVer() + ": " + s + " (" + c + ".class)"), (String)"skUtilities.warning");
        }
    }

    public static void prSysi(String s) {
        Bukkit.getServer().getLogger().info("[skUtilities] v" + skUtilities.getVer() + ": " + s);
    }

    static void loadErr(String s) {
        Bukkit.getServer().getLogger().severe("[skUtilities] v" + skUtilities.getVer() + " - Failed to load:  " + s + ", due to not using 1.9+!");
    }

    private void updateChk() {
        skUtilities.prSysi("Checking for update now you will be notified if there is an update!");
        String v = "";
        try {
            BufferedReader ur = new BufferedReader(new InputStreamReader(new URL("https://raw.githubusercontent.com/tim740/skUtilities/master/latest.ver").openStream()));
            v = ur.readLine();
            ur.close();
        }
        catch (Exception exception) {
            skUtilities.prSys("Error while checking for update!", "Main", 0);
        }
        if (!Objects.equals(skUtilities.getVer(), v)) {
            skUtilities.prSysi("A new version of the addon is out v" + v);
            if (this.getConfig().getBoolean("downloadUpdates", true)) {
                String dln = "plugins" + File.separator + "skUtilities" + File.separator + "skUtilities.v" + v + ".jar";
                if (!new File(dln).exists()) {
                    skUtilities.prSysi("Downloading latest version!");
                    Utils.downloadFile(new File(dln), "https://github.com/tim740/skUtilities/releases/download/v" + v + "/skUtilities.v" + v + ".jar");
                    skUtilities.prSysi("Latest version has been downloaded!");
                } else {
                    skUtilities.prSysi("Latest version of skUtilities (v" + v + ") is already downloaded and ready to use!");
                }
            } else {
                skUtilities.prSysi("You can find the latest version here: https://github.com/tim740/skUtilities/releases/latest");
            }
        } else {
            skUtilities.prSysi("It seems like your using the latest version!");
        }
    }

    private static String getVer() {
        return Bukkit.getPluginManager().getPlugin("skUtilities").getDescription().getVersion();
    }

    private void resetConfig() {
        File pth = new File(String.valueOf(this.getDataFolder().getAbsolutePath()) + File.separator + "config.yml");
        File ptho = new File(String.valueOf(this.getDataFolder().getAbsolutePath()) + File.separator + "config.old");
        if (ptho.exists()) {
            ptho.delete();
        }
        pth.renameTo(ptho);
        this.saveDefaultConfig();
        skUtilities.prSysi("");
        skUtilities.prSysi("You where using an old version of the config!");
        skUtilities.prSysi("It was copied and renamed to 'config.old'");
        skUtilities.prSysi("A new config has been generated!");
        skUtilities.prSysi("Sorry but all the options have been reset.");
        skUtilities.prSysi("");
    }
}

