/*
 * Decompiled with CFR 0.152.
 */
package com.skunity.plugin.utils;

import com.skunity.plugin.Logger;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;

public class PlayerChat {
    private Player p;
    private CommandSender s = null;
    private PlayerChatMode playerChatMode;

    public PlayerChat(Player player) {
        this.p = player;
        this.playerChatMode = PlayerChatMode.PLAYER;
    }

    public PlayerChat(CommandSender sender) {
        this.s = sender;
        if (sender instanceof Player) {
            this.setPlayer((Player)sender);
            this.playerChatMode = PlayerChatMode.BOTH;
        } else {
            this.playerChatMode = sender instanceof ConsoleCommandSender ? PlayerChatMode.LOGGER : PlayerChatMode.COMMAND_SENDER;
        }
    }

    public PlayerChat(Class<?> clazz) {
        if (clazz.equals(Logger.class)) {
            this.playerChatMode = PlayerChatMode.LOGGER;
        }
    }

    public void setPlayer(Player player) {
        this.p = player;
        this.playerChatMode = this.s == null ? PlayerChatMode.PLAYER : PlayerChatMode.BOTH;
    }

    public Player getPlayer() {
        return this.p;
    }

    public CommandSender getCommandSender() {
        return this.s;
    }

    public void sendHeader() {
        this.sendMessage("&4&m----------&r &fsk&c&lUnity &4&m----------------------------");
        this.sendMessage(" ");
    }

    public void sendBlank() {
        this.sendMessage(" ");
    }

    public void sendMessage(String ... messageArray) {
        String[] stringArray = messageArray;
        int n = messageArray.length;
        int n2 = 0;
        while (n2 < n) {
            String message = stringArray[n2];
            if (this.playerChatMode == PlayerChatMode.PLAYER || this.playerChatMode == PlayerChatMode.BOTH) {
                this.p.sendMessage(this.format(message));
            } else if (this.playerChatMode == PlayerChatMode.COMMAND_SENDER) {
                this.s.sendMessage(this.format(message));
            } else if (this.playerChatMode == PlayerChatMode.LOGGER) {
                Logger.info(this.format(message));
            }
            ++n2;
        }
    }

    public void title(String message) {
        this.sendMessage("&6&l" + message);
    }

    public void info(String message) {
        this.sendMessage("&7" + message);
    }

    public void warning(String message) {
        this.sendMessage("&c" + message);
    }

    public void severe(String message) {
        this.sendMessage("&4" + message);
    }

    public void success(String message) {
        this.sendMessage("&a" + message);
    }

    public String format(String message) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }

    public ChatColor getChatColour(String type) {
        if (type == "warning") {
            return ChatColor.RED;
        }
        if (type == "severe") {
            return ChatColor.DARK_RED;
        }
        if (type == "success") {
            return ChatColor.GREEN;
        }
        if (type == "info") {
            return ChatColor.GRAY;
        }
        return ChatColor.GRAY;
    }

    public String getChatColourString(String type) {
        if (type == "warning") {
            return "&c";
        }
        if (type == "severe") {
            return "&4";
        }
        if (type == "success") {
            return "&a";
        }
        if (type == "info") {
            return "&7";
        }
        return "&7";
    }

    public void sendJSONCommandHover(String playerMessage, ChatColor colour, String command, String hoverText, ChatColor hoverColour) {
        if (this.playerChatMode == PlayerChatMode.LOGGER) {
            this.sendMessage(playerMessage, "[Command: " + command + "]", "[Hover: " + hoverText + "]");
            return;
        }
        TextComponent message = new TextComponent(playerMessage);
        message.setColor(colour);
        message.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, command));
        ComponentBuilder hoverComponent = new ComponentBuilder(hoverText);
        hoverComponent.color(hoverColour);
        message.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, hoverComponent.create()));
        this.getPlayer().spigot().sendMessage((BaseComponent)message);
    }

    public void sendJSONCommand(String playerMessage, ChatColor colour, String command) {
        if (this.playerChatMode == PlayerChatMode.LOGGER) {
            this.sendMessage(playerMessage, "[Command: " + command + "]");
            return;
        }
        TextComponent message = new TextComponent(playerMessage);
        message.setColor(colour);
        message.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, command));
        this.getPlayer().spigot().sendMessage((BaseComponent)message);
    }

    public void sendJSONHover(String playerMessage, ChatColor colour, String hoverText, ChatColor hoverColour) {
        if (this.playerChatMode == PlayerChatMode.LOGGER) {
            this.sendMessage(playerMessage, "[Hover: " + hoverText + "]");
            return;
        }
        TextComponent message = new TextComponent(playerMessage);
        message.setColor(colour);
        ComponentBuilder hoverComponent = new ComponentBuilder(hoverText);
        hoverComponent.color(hoverColour);
        message.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, hoverComponent.create()));
        this.getPlayer().spigot().sendMessage((BaseComponent)message);
    }

    public void sendColonSplit(String pre, String suf, Boolean allowNoValue) {
        if (suf.equalsIgnoreCase("")) {
            if (allowNoValue.booleanValue()) {
                this.sendMessage(String.valueOf(this.getChatColourString("warning")) + pre + ": " + this.getChatColourString("info") + suf);
            }
        } else {
            this.sendMessage(String.valueOf(this.getChatColourString("warning")) + pre + ": " + this.getChatColourString("info") + suf);
        }
    }

    public void sendColonSplit(String pre, String suf) {
        this.sendColonSplit(pre, suf, true);
    }

    public void sendJSONHoverColon(String pre, String suf, String hoverText) {
        if (this.playerChatMode == PlayerChatMode.LOGGER) {
            this.sendMessage(String.valueOf(pre) + ": " + suf, "[Hover: " + hoverText + "]");
            return;
        }
        TextComponent message = new TextComponent(String.valueOf(pre) + ": ");
        message.setColor(this.getChatColour("warning"));
        TextComponent world = new TextComponent(suf);
        world.setColor(this.getChatColour("info"));
        ComponentBuilder hoverComponent = new ComponentBuilder(hoverText);
        hoverComponent.color(this.getChatColour("info"));
        world.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, hoverComponent.create()));
        message.addExtra((BaseComponent)world);
        this.getPlayer().spigot().sendMessage((BaseComponent)message);
    }

    public void sendJSONHoverURLColon(String pre, String suf, String hoverText, String url) {
        if (this.playerChatMode == PlayerChatMode.LOGGER) {
            this.sendMessage(String.valueOf(pre) + ": " + suf, "[Hover: " + hoverText + "]", "[URL: " + url + "]");
            return;
        }
        TextComponent message = new TextComponent(String.valueOf(pre) + ": ");
        message.setColor(this.getChatColour("warning"));
        TextComponent world = new TextComponent(suf);
        world.setColor(this.getChatColour("info"));
        world.setClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, url));
        ComponentBuilder hoverComponent = new ComponentBuilder(hoverText);
        hoverComponent.color(this.getChatColour("info"));
        world.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, hoverComponent.create()));
        message.addExtra((BaseComponent)world);
        this.getPlayer().spigot().sendMessage((BaseComponent)message);
    }

    public void sendJSONHoverCommandColon(String pre, String suf, String hoverText, String command) {
        if (this.playerChatMode == PlayerChatMode.LOGGER) {
            this.sendMessage(String.valueOf(pre) + ": " + suf, "[Hover: " + hoverText + "]", "[Command: " + command + "]");
            return;
        }
        TextComponent message = new TextComponent(String.valueOf(pre) + ": ");
        message.setColor(this.getChatColour("warning"));
        TextComponent world = new TextComponent(suf);
        world.setColor(this.getChatColour("info"));
        world.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, command));
        ComponentBuilder hoverComponent = new ComponentBuilder(hoverText);
        hoverComponent.color(this.getChatColour("info"));
        world.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, hoverComponent.create()));
        message.addExtra((BaseComponent)world);
        this.getPlayer().spigot().sendMessage((BaseComponent)message);
    }

    public static enum PlayerChatMode {
        PLAYER,
        COMMAND_SENDER,
        BOTH,
        LOGGER;

    }
}

