/*
 * Decompiled with CFR 0.152.
 */
package com.skunity.plugin.utils;

import ch.njol.skript.Skript;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.skunity.plugin.Config;
import com.skunity.plugin.Logger;
import com.skunity.plugin.Main;
import com.skunity.plugin.files.SKUFile;
import com.skunity.plugin.files.SKUResourceData;
import com.skunity.plugin.utils.HttpDownloadUtility;
import com.skunity.plugin.utils.PlayerChat;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class CoreUtil {
    public static String API_URL;
    public static String DOCS_API_URL;
    public static HashMap<String, SKUFile> fileCache;
    private static Pattern doublePattern;

    static {
        fileCache = new HashMap();
        doublePattern = Pattern.compile("-?\\d+(\\.\\d*)?");
    }

    public static void setAPIURL() {
        API_URL = "https://docs.skunity.com/api/?function=forumsAPI&key=" + Config.API_KEY + "&request=";
        DOCS_API_URL = "https://docs.skunity.com/api/?&key=" + Config.API_KEY + "&function=";
    }

    public static String booleanToString(Boolean b) {
        return b != false ? "yes" : "no";
    }

    public static ArrayList<SKUFile> getFiles(String directory, Boolean recursive) {
        return CoreUtil.getFiles(directory, recursive, true);
    }

    public static ArrayList<SKUFile> getFiles(String directory, Boolean recursive, Boolean intilise) {
        File path = new File(directory);
        File[] files = path.listFiles();
        ArrayList<SKUFile> outputFiles = new ArrayList<SKUFile>();
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File tempFile = fileArray[n2];
            if (tempFile.isFile()) {
                if (tempFile.getName().endsWith(".sk") || tempFile.getName().endsWith(".jar")) {
                    if (tempFile.getName().startsWith("-")) {
                        if (!Config.IGNORE_DISABLED_SCRIPTS) {
                            outputFiles.add(new SKUFile(tempFile, intilise));
                        }
                    } else {
                        outputFiles.add(new SKUFile(tempFile, intilise));
                    }
                }
            } else if (recursive.booleanValue() && Config.RECURSIVE_SCRIPTS_FOLDER_SEARCH) {
                String tempDirectory = directory.endsWith("/") ? String.valueOf(directory) + tempFile : String.valueOf(directory) + "/" + tempFile;
                for (SKUFile otherFile : CoreUtil.getFiles(tempDirectory, recursive)) {
                    outputFiles.add(otherFile);
                }
            }
            ++n2;
        }
        return outputFiles;
    }

    public static SKUFile resolveFile(String originalInput) {
        String input = CoreUtil.makeFilename(originalInput, ".sk");
        SKUFile foundFile = null;
        ArrayList<SKUFile> scripts = CoreUtil.getFiles("./plugins/Skript/scripts/", true, false);
        for (SKUFile script : scripts) {
            if (!script.getFile().getName().equalsIgnoreCase(input) && !script.getHash().equalsIgnoreCase(originalInput)) continue;
            foundFile = script;
            break;
        }
        if (foundFile == null) {
            input = CoreUtil.makeFilename(originalInput, ".jar");
            ArrayList<SKUFile> addons = CoreUtil.getFiles("./plugins/", false, false);
            for (SKUFile script : addons) {
                if (!script.getFile().getName().equalsIgnoreCase(input) && !script.getHash().equalsIgnoreCase(originalInput)) continue;
                foundFile = script;
                break;
            }
        }
        if (foundFile == null) {
            return null;
        }
        foundFile.intilise();
        return foundFile;
    }

    public static String makeFilename(String input, String extension) {
        if (!input.endsWith(extension)) {
            input = String.valueOf(input) + extension;
        }
        return input;
    }

    public static void cacheFile(String hash, SKUFile file) {
        if (fileCache.containsKey(hash)) {
            fileCache.remove(hash);
        }
        fileCache.put(hash, file);
    }

    public static SKUFile getFile(String hash) {
        if (fileCache.containsKey(hash)) {
            return fileCache.get(hash);
        }
        return null;
    }

    public static String doAPIRequest(String function, String args) {
        String line = "";
        try {
            URL url = new URL(String.valueOf(API_URL) + function + args);
            Logger.debug("Request made to " + API_URL + function + args);
            URLConnection connection = url.openConnection();
            connection.setRequestProperty("User-Agent", "The official skUnity Plugin");
            BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            line = in.readLine();
            in.close();
            Logger.debug("Response: " + line);
        }
        catch (MalformedURLException e) {
            System.out.println("Malformed URL: " + e.getMessage());
        }
        catch (IOException e) {
            System.out.println("I/O Error: " + e.getMessage());
        }
        return line;
    }

    public static String doDocsAPIRequest(String function, String args) {
        String line = "";
        try {
            URL url = new URL(String.valueOf(DOCS_API_URL) + function + args);
            Logger.debug("Request made to " + DOCS_API_URL + function + args);
            URLConnection connection = url.openConnection();
            connection.setRequestProperty("User-Agent", "The official skUnity Plugin");
            BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            line = in.readLine();
            in.close();
            Logger.debug("Response: " + line);
        }
        catch (MalformedURLException e) {
            System.out.println("Malformed URL: " + e.getMessage());
        }
        catch (IOException e) {
            System.out.println("I/O Error: " + e.getMessage());
        }
        return line;
    }

    public static String getData(String md5) {
        String line = "";
        try {
            URL url = new URL(String.valueOf(API_URL) + "skUnityAutoUpdater&hash=" + md5);
            Logger.debug("Request made to " + API_URL + "skUnityAutoUpdater&hash=" + md5);
            URLConnection connection = url.openConnection();
            connection.setRequestProperty("User-Agent", "The official skUnity Plugin");
            BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            line = in.readLine();
            in.close();
            Logger.info("Response: " + line);
        }
        catch (MalformedURLException e) {
            System.out.println("Malformed URL: " + e.getMessage());
        }
        catch (IOException e) {
            System.out.println("I/O Error: " + e.getMessage());
        }
        return line;
    }

    public static Boolean downloadFile(String downloadURL, String path, PlayerChat PlayerChat2, String success, String failed) {
        try {
            File newFile = HttpDownloadUtility.downloadFile(downloadURL, path);
            if (newFile.exists()) {
                PlayerChat2.success(success);
                return true;
            }
            PlayerChat2.warning(failed);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    public static Boolean justDownloadFile(String downloadURL, String path) {
        try {
            File newFile = HttpDownloadUtility.downloadFile(downloadURL, path);
            if (newFile.exists()) {
                return true;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    public static File returndownloadFile(String downloadURL, String path, PlayerChat PlayerChat2, String success, String failed) {
        try {
            File newFile = HttpDownloadUtility.downloadFile(downloadURL, path);
            if (newFile.exists()) {
                PlayerChat2.success(success);
                return newFile;
            }
            PlayerChat2.warning(failed);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static File justReturndownloadFile(String downloadURL, String path) {
        try {
            File newFile = HttpDownloadUtility.downloadFile(downloadURL, path);
            if (newFile.exists()) {
                return newFile;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String getTypeFromString(String input) {
        if (input.startsWith("'") && input.endsWith("'")) {
            return "String";
        }
        if (input == "true" || input == "false") {
            return "Boolean";
        }
        if (CoreUtil.isDouble(input)) {
            return "Double";
        }
        if (StringUtils.isNumeric((String)input)) {
            return "Integer";
        }
        return "String";
    }

    public static boolean isDouble(String string) {
        return doublePattern.matcher(string).matches();
    }

    public static SKUResourceData getResourceData(String resourceId) {
        String json = CoreUtil.doAPIRequest("getResource", "&resourceid=" + resourceId);
        JsonArray jsonData = Main.commandUtils.parseJSON(json);
        JsonObject jsonObject = null;
        Iterator iterator = jsonData.iterator();
        if (iterator.hasNext()) {
            JsonElement jE = (JsonElement)iterator.next();
            JsonObject jO = jE.getAsJsonObject();
            if (jO.get("result").getAsString().equalsIgnoreCase("success")) {
                jsonObject = jO;
            } else {
                return null;
            }
        }
        if (jsonObject == null) {
            return null;
        }
        return new SKUResourceData(jsonObject);
    }

    public static Boolean allowLateSkriptRegisteration(Boolean allowReg) {
        try {
            Field field = Skript.class.getDeclaredField("acceptRegistrations");
            field.setAccessible(true);
            field.set(null, allowReg);
            return true;
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            return false;
        }
    }
}

