/*
 * Decompiled with CFR 0.152.
 */
package com.skunity.plugin.files;

import com.google.common.io.Files;
import com.skunity.plugin.Main;
import com.skunity.plugin.files.SKUFile;
import java.io.File;
import java.io.IOException;

public class BackupFile {
    private File originalFile;
    private File backedupFile;
    private Boolean isBackedUp;

    public BackupFile(SKUFile file) {
        new BackupFile(file.getFile());
    }

    public BackupFile(File file) {
        this.originalFile = file;
        this.isBackedUp = false;
    }

    public void createBackup() {
        if (!this.isBackedUp.booleanValue() && this.originalFile.exists()) {
            try {
                File maybeFile = new File(String.valueOf(Main.backupsFolder.getPath()) + "/" + this.originalFile.getName());
                if (maybeFile.exists()) {
                    long dateL = System.currentTimeMillis() / 1000L;
                    maybeFile.renameTo(new File(String.valueOf(Main.backupsFolder.getPath()) + "/" + dateL + "-" + this.originalFile.getName()));
                }
                Files.move((File)this.originalFile, (File)maybeFile);
                this.backedupFile = maybeFile;
                this.isBackedUp = true;
            }
            catch (IOException e) {
                e.printStackTrace();
                this.isBackedUp = false;
            }
        }
    }

    public void restoreBackup() {
        if (this.isBackedUp.booleanValue() && this.backedupFile.exists()) {
            try {
                Files.move((File)this.backedupFile, (File)this.originalFile);
                this.isBackedUp = false;
            }
            catch (IOException e) {
                e.printStackTrace();
                this.isBackedUp = true;
            }
        }
    }
}

