/*
 * Decompiled with CFR 0.152.
 */
package com.skunity.plugin.commands;

import com.skunity.plugin.Main;
import com.skunity.plugin.SkunityCommand;
import com.skunity.plugin.files.SKUFile;
import com.skunity.plugin.utils.CommandUtils;
import com.skunity.plugin.utils.CoreUtil;
import com.skunity.plugin.utils.ListMessage;
import com.skunity.plugin.utils.PlayerChat;
import com.skunity.plugin.utils.SKUSubCommand;
import com.skunity.plugin.utils.SKUSubCommandInfo;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.command.CommandSender;

public class SKUInfo
extends SKUSubCommand {
    static PlayerChat PlayerChat;
    static CommandUtils CommandUtils;

    public SKUInfo() {
        SKUSubCommandInfo info = new SKUSubCommandInfo();
        info.command = "info";
        info.permission = "skunity.command.info";
        info.aliases = new String[]{""};
        info.description = "Get info on a specific script or plugin. List all your content by doing /sku info";
        info.usage = "/sku info [scripts|plugins|{all}]";
        Main.getCommandRegistry().setInfo(this, info);
    }

    public static void listMessageHandler(Integer soFar, String msg) {
        TextComponent message = new TextComponent(TextComponent.fromLegacyText((String)msg));
        message.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "sku info"));
        ComponentBuilder hoverComponent = new ComponentBuilder("Click for more information");
        hoverComponent.color(PlayerChat.getChatColour("warning"));
        message.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, hoverComponent.create()));
        PlayerChat.getPlayer().spigot().sendMessage((BaseComponent)message);
        ListMessage.sendButtons(PlayerChat, soFar, 1);
    }

    @Override
    public void execute(SkunityCommand skUnity, CommandSender sender, String alias, String[] args) {
        PlayerChat = skUnity.getPlayerChat();
        CommandUtils = skUnity.getCommandUtils();
        String out_of_date = "Here's all of your content";
        if (args.length == 1 || args.length == 2 && args[1].equalsIgnoreCase("all")) {
            PlayerChat.info(out_of_date);
            PlayerChat.info("Scripts:");
            CommandUtils.logUpdateInfo(CommandUtils.checkScripts(), PlayerChat.getChatColour("warning"), "/sku info %hash%", "Click for more information about %title%", false);
            PlayerChat.info("Plugins:");
            CommandUtils.logUpdateInfo(CommandUtils.checkPlugins(), PlayerChat.getChatColour("warning"), "/sku info %hash%", "Click for more information about %title%", false);
            return;
        }
        if (args[1].equalsIgnoreCase("scripts")) {
            PlayerChat.info(out_of_date);
            PlayerChat.info("Scripts:");
            CommandUtils.logUpdateInfo(CommandUtils.checkScripts(), PlayerChat.getChatColour("warning"), "/sku info %hash%", "Click for more information about %title%", false);
            return;
        }
        if (args[1].equalsIgnoreCase("plugins")) {
            PlayerChat.info(out_of_date);
            PlayerChat.info("Plugins:");
            CommandUtils.logUpdateInfo(CommandUtils.checkPlugins(), PlayerChat.getChatColour("warning"), "/sku info %hash%", "Click for more information about %title%", false);
            return;
        }
        if (args.length >= 2) {
            SKUFile foundFile = CoreUtil.resolveFile(args[1]);
            if (foundFile == null) {
                PlayerChat.warning("Unable to find any script or addon with the name/hash of: " + args[1]);
            } else if (args.length >= 2) {
                PlayerChat.sendColonSplit("Name", foundFile.getFile().getName());
                PlayerChat.sendJSONHoverColon("Path", foundFile.getFile().getPath(), foundFile.getFile().getAbsolutePath());
                if (foundFile.isJSONReady().booleanValue()) {
                    PlayerChat.sendColonSplit("On skUnity", CoreUtil.booleanToString(foundFile.onSkUnity()));
                    PlayerChat.sendJSONHoverURLColon("Author", foundFile.getResourceData().author, "View the authors skUnity Resources profile", foundFile.getURL("author"));
                    PlayerChat.sendJSONHoverURLColon("Resource Title", foundFile.getResourceData().title, "View this Resources page on skUnity", foundFile.getURL("page"));
                    if (foundFile.getResourceData().is_latest.booleanValue()) {
                        PlayerChat.sendJSONHoverColon("Is Latest", CoreUtil.booleanToString(foundFile.getResourceData().is_latest), "You're running the latest version (" + foundFile.getResourceData().version_string + ")");
                    } else {
                        PlayerChat.sendJSONHoverCommandColon("Is Latest", CoreUtil.booleanToString(foundFile.getResourceData().is_latest), "Click here to update", "/sku update " + foundFile.getHash());
                    }
                }
            }
        } else {
            PlayerChat.warning("You must provide a file name or hash to see the information about it");
        }
    }
}

