/*
 * Decompiled with CFR 0.152.
 */
package com.skunity.plugin.utils;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.skunity.plugin.Config;
import com.skunity.plugin.files.SKUFile;
import com.skunity.plugin.utils.CoreUtil;
import com.skunity.plugin.utils.PlayerChat;
import java.util.ArrayList;
import java.util.Iterator;
import net.md_5.bungee.api.ChatColor;

public class CommandUtils {
    private PlayerChat PlayerChat;

    public CommandUtils(PlayerChat playerChatClass) {
        this.PlayerChat = playerChatClass;
    }

    public String jsonHas(JsonObject jO, String key) {
        if (jO.has(key)) {
            return jO.get(key).getAsString();
        }
        return "";
    }

    public String customReplace(JsonObject jO, String parse) {
        parse = parse.replaceAll("%title%", this.jsonHas(jO, "title"));
        parse = parse.replaceAll("%hash%", this.jsonHas(jO, "hash"));
        parse = parse.replaceAll("%resource_id%", this.jsonHas(jO, "resource_id"));
        parse = parse.replaceAll("%id%", this.jsonHas(jO, "id"));
        parse = parse.replaceAll("%name%", this.jsonHas(jO, "name"));
        parse = parse.replaceAll("%addon%", this.jsonHas(jO, "addon"));
        if (jO.has("title")) {
            parse = parse.replaceAll("%title-32%", this.cutTitle(jO.get("title"), 32));
        }
        if (jO.has("name")) {
            parse = parse.replaceAll("%name-32%", this.cutTitle(jO.get("name"), 32));
        }
        return parse;
    }

    public void logUpdateInfo(JsonArray jsonArray, ChatColor mainTextColour, String command, String hover, Boolean showOutOfDate) {
        this.logUpdateInfo(jsonArray, mainTextColour, command, hover, showOutOfDate, null);
    }

    public void logUpdateInfo(JsonArray jsonArray, ChatColor mainTextColour, String command, String hover, Boolean showOutOfDate, String title) {
        if (jsonArray == null) {
            this.PlayerChat.warning(" \u00bb No content was found that is on skUnity");
            return;
        }
        Integer i = 0;
        UpdateOutput uino = UpdateOutput.UNSET;
        for (JsonElement jE : jsonArray) {
            i = i + 1;
            JsonObject jO = jE.getAsJsonObject();
            if (!jO.has("result")) {
                jO.addProperty("result", "success");
            }
            if (!jO.get("result").getAsString().equalsIgnoreCase("success")) continue;
            if (showOutOfDate.booleanValue() && jO.get("is_latest").getAsBoolean()) {
                if (uino != UpdateOutput.UNSET) continue;
                uino = UpdateOutput.UP_TO_DATE;
                continue;
            }
            uino = UpdateOutput.DONE;
            if (title == null) {
                this.PlayerChat.sendJSONCommandHover(" \u00bb [" + i + "] " + this.cutTitle(jO.get("title"), 32) + " by " + jO.get("author").getAsString(), mainTextColour, this.customReplace(jO, command), this.customReplace(jO, hover), this.PlayerChat.getChatColour("warning"));
                continue;
            }
            this.PlayerChat.sendJSONCommandHover(" \u00bb [" + i + "] " + this.customReplace(jO, title), mainTextColour, this.customReplace(jO, command), this.customReplace(jO, hover), this.PlayerChat.getChatColour("warning"));
        }
        if (uino == UpdateOutput.UNSET) {
            uino = UpdateOutput.NOTHING;
        }
        if (uino != UpdateOutput.DONE) {
            this.PlayerChat.warning(uino.getValue());
        }
    }

    public String cutTitle(JsonElement input, Integer cutLength) {
        return this.cutString(input.getAsString(), cutLength);
    }

    public String cutString(String input, Integer cutLength) {
        if (input.length() <= cutLength) {
            return input;
        }
        String tString = input.substring(0, cutLength);
        if (tString.endsWith(",") || tString.endsWith(" ")) {
            tString = tString.substring(0, tString.length() - 1);
        }
        if (tString.endsWith(" ") || tString.endsWith(",")) {
            tString = tString.substring(0, tString.length() - 1);
        }
        return String.valueOf(tString) + "...";
    }

    public JsonArray runCheck(String path, Boolean recursive) {
        ArrayList<SKUFile> scripts = CoreUtil.getFiles(path, recursive, false);
        String md5s = null;
        Integer counter = -1;
        for (SKUFile script : scripts) {
            CoreUtil.cacheFile(script.getHash(), script);
            counter = counter + 1;
            md5s = md5s == null ? script.getHash() : String.valueOf(md5s) + "," + script.getHash();
        }
        String json = CoreUtil.getData(md5s);
        JsonArray jsonData = this.parseJSON(json);
        for (JsonElement jE : jsonData) {
            SKUFile script;
            JsonObject jO = jE.getAsJsonObject();
            if (!jO.get("result").getAsString().equalsIgnoreCase("success") || (script = CoreUtil.getFile(jO.get("hash").getAsString())) == null) continue;
            script.setJSONData(jO);
            CoreUtil.cacheFile(script.getHash(), script);
        }
        return jsonData;
    }

    public JsonArray parseJSON(String json) {
        JsonArray result = null;
        try {
            JsonObject jsonObject = new JsonParser().parse(json).getAsJsonObject();
            result = jsonObject.getAsJsonArray("result");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public JsonObject readJSON(String json) {
        JsonObject result = null;
        try {
            result = new JsonParser().parse(json).getAsJsonObject();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public JsonArray getJsonArray(String json, String array) {
        JsonArray result = null;
        try {
            JsonObject jsonObject = new JsonParser().parse(json).getAsJsonObject();
            result = jsonObject.getAsJsonArray(array);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public JsonObject getJsonObject(String json) {
        JsonObject jsonObject = null;
        try {
            jsonObject = new JsonParser().parse(json).getAsJsonObject();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return jsonObject;
    }

    public Object jsonArrayGet(JsonArray array, String member) {
        Iterator iterator = array.iterator();
        if (iterator.hasNext()) {
            JsonElement jE = (JsonElement)iterator.next();
            JsonObject jO = jE.getAsJsonObject();
            return jO.get(member);
        }
        return null;
    }

    public JsonArray checkScripts() {
        return this.runCheck("./plugins/Skript/scripts/", Config.RECURSIVE_SCRIPTS_FOLDER_SEARCH);
    }

    public JsonArray checkPlugins() {
        return this.runCheck("./plugins/", false);
    }

    public static enum UpdateOutput {
        NOTHING(" \u00bb No content was found that is on skUnity"),
        UP_TO_DATE(" \u00bb All of your content is up to date!"),
        DONE(""),
        UNSET(" \u00bb Oops! It looks like something went wrong!");

        private final String message;

        private UpdateOutput(String message) {
            this.message = message;
        }

        public String getValue() {
            return this.message;
        }
    }
}

