/*
 * Decompiled with CFR 0.152.
 */
package com.skunity.plugin.files;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.skunity.plugin.Main;
import com.skunity.plugin.files.SKUResourceData;
import com.skunity.plugin.utils.CoreUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import org.apache.commons.codec.digest.DigestUtils;

public class SKUFile {
    private String md5 = null;
    private String path;
    private File file;
    private JsonObject jsonData = null;
    private Boolean onSkUnity = false;
    private HashMap<String, String> urlData = new HashMap();
    private SKUResourceData resourceData;

    public SKUFile(File path, Boolean intilise) {
        this.path = path.getPath();
        this.file = path;
        try {
            FileInputStream fis = new FileInputStream(path);
            this.md5 = DigestUtils.md5Hex((InputStream)fis);
            fis.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        if (intilise.booleanValue()) {
            this.intilise();
        }
    }

    public SKUFile(File path) {
        this(path, true);
    }

    public void intilise() {
        if (this.jsonData == null) {
            this.fetchJSONData();
        }
        if (this.jsonData != null) {
            this.resourceData = new SKUResourceData(this.jsonData);
            this.assignURLs();
        }
    }

    public SKUResourceData getResourceData() {
        return this.resourceData;
    }

    public void setJSONData(JsonObject data) {
        this.jsonData = data;
    }

    public JsonObject getJSONData() {
        if (this.jsonData == null) {
            this.fetchJSONData();
        }
        return this.jsonData;
    }

    public String getHash() {
        return this.md5 == null ? "" : this.md5;
    }

    public String getPath() {
        return this.path;
    }

    public File getFile() {
        return this.file;
    }

    public Boolean onSkUnity() {
        return this.onSkUnity;
    }

    public void assignURLs() {
        if (this.isJSONReady().booleanValue()) {
            this.assignURL("author", String.format("https://forums.skunity.com/resources/authors/%s.%s/", this.resourceData.author, this.resourceData.author_id));
            this.assignURL("download", String.format("https://forums.skunity.com/resources/%s/download?version=%s", this.resourceData.resource_id, this.resourceData.latest_version));
            this.assignURL("page", String.format("https://forums.skunity.com/resources/%s/", this.resourceData.resource_id));
        }
    }

    public void assignURL(String key, String value) {
        this.urlData.put(key, value);
    }

    public String getURL(String key) {
        if (this.urlData.containsKey(key)) {
            return this.urlData.get(key);
        }
        return "";
    }

    public Boolean fetchJSONData() {
        if (this.md5 == null) {
            return false;
        }
        String json = CoreUtil.getData(this.md5);
        JsonArray jsonData = Main.commandUtils.parseJSON(json);
        for (JsonElement jE : jsonData) {
            JsonObject jO = jE.getAsJsonObject();
            if (jO.get("result").getAsString().equalsIgnoreCase("success")) {
                this.setJSONData(jO);
                CoreUtil.cacheFile(this.getHash(), this);
                this.onSkUnity = true;
                continue;
            }
            this.onSkUnity = false;
        }
        return this.onSkUnity;
    }

    public Boolean isJSONReady() {
        if (this.md5 == null) {
            return false;
        }
        if (this.jsonData == null) {
            this.intilise();
            if (this.jsonData == null) {
                return false;
            }
        }
        return true;
    }

    public String getDownloadURL() {
        if (!this.isJSONReady().booleanValue()) {
            this.intilise();
        }
        return this.resourceData.download_url;
    }
}

