/*
 * Decompiled with CFR 0.152.
 */
package com.skunity.plugin.utils;

import com.skunity.plugin.Logger;
import com.skunity.plugin.utils.ChangeLineInFile;
import com.skunity.plugin.utils.ConfigData;
import com.skunity.plugin.utils.CoreUtil;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.lang.StringUtils;
import org.bukkit.plugin.java.JavaPlugin;

public class YAMLManager {
    private JavaPlugin plugin;
    private File file;
    private HashMap<String, ConfigData> configDataMap = new HashMap();
    private Boolean isLoaded = false;

    public YAMLManager(JavaPlugin p, File f) {
        this.plugin = p;
        this.file = f;
        this.load();
    }

    public YAMLManager(JavaPlugin p, File f, Boolean autoLoad) {
        this.plugin = p;
        this.file = f;
        if (autoLoad.booleanValue()) {
            this.load();
        }
    }

    public void ensureLoaded() {
        if (!this.isLoaded().booleanValue()) {
            this.load();
        }
    }

    public Boolean isLoaded() {
        return this.isLoaded;
    }

    public void load() {
        this.isLoaded = true;
        this.configDataMap = new HashMap();
        if (this.file == null) {
            Logger.severe("Unable to access the config file!");
            return;
        }
        try (LineIterator it = FileUtils.lineIterator((File)this.file, (String)"UTF-8");){
            while (it.hasNext()) {
                String line = it.nextLine();
                if (line.startsWith("#") || line == "" || line == " " || line == System.lineSeparator()) continue;
                String[] lineSplit = null;
                if (line.contains(": ")) {
                    lineSplit = line.split(": ");
                } else {
                    if (!line.contains(":")) continue;
                    lineSplit = line.split(":");
                }
                if (lineSplit == null) continue;
                ConfigData cd = new ConfigData(lineSplit[0], lineSplit[1]);
                this.configDataMap.put(lineSplit[0], cd);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public ConfigData getConfigData(String key) {
        if (this.configDataMap.containsKey(key)) {
            return this.configDataMap.get(key);
        }
        Logger.severe("skUnity tried to access '" + key + "', however, there was no value for it. Is your config out of date?");
        return null;
    }

    public String getString(String key) {
        ConfigData cd = this.getConfigData(key);
        if (cd == null) {
            return "";
        }
        return cd.value;
    }

    public Double getDouble(String key) {
        ConfigData cd = this.getConfigData(key);
        if (cd == null) {
            return 0.0;
        }
        if (CoreUtil.isDouble(cd.value)) {
            return Double.valueOf(cd.value);
        }
        return 0.0;
    }

    public Integer getInt(String key) {
        return this.getInteger(key);
    }

    public Integer getInteger(String key) {
        ConfigData cd = this.getConfigData(key);
        if (cd == null) {
            return 0;
        }
        if (StringUtils.isNumeric((String)cd.value)) {
            return Integer.valueOf(cd.value);
        }
        return 0;
    }

    public Boolean getBoolean(String key) {
        ConfigData cd = this.getConfigData(key);
        if (cd == null) {
            return false;
        }
        if (cd.value.equalsIgnoreCase("true") || cd.value.equalsIgnoreCase("false")) {
            return Boolean.valueOf(cd.value);
        }
        return false;
    }

    public void update(Integer highestConfigVersion) {
        this.ensureLoaded();
        Integer configVersion = this.getInteger("config-version");
        if (highestConfigVersion <= configVersion) {
            return;
        }
        this.file.delete();
        this.plugin.saveDefaultConfig();
        this.plugin.getConfig().options().copyDefaults(true);
        try {
            Integer lineNumber = 0;
            String sFile = this.file.getAbsolutePath();
            try (LineIterator it = FileUtils.lineIterator((File)this.file, (String)"UTF-8");){
                while (it.hasNext()) {
                    lineNumber = lineNumber + 1;
                    String line = it.nextLine();
                    if (line.startsWith("#") || line == "" || line == " " || line == System.lineSeparator()) continue;
                    String[] lineSplit = null;
                    if (line.contains(": ")) {
                        lineSplit = line.split(": ");
                    } else {
                        if (!line.contains(":")) continue;
                        lineSplit = line.split(":");
                    }
                    if (lineSplit == null || this.configDataMap.get(lineSplit[0]) == null) continue;
                    if (lineSplit[0].equalsIgnoreCase("config-version")) {
                        ConfigData cd = new ConfigData(lineSplit[0], String.valueOf(highestConfigVersion));
                        this.configDataMap.put(lineSplit[0], cd);
                    }
                    if (lineSplit[1] == this.configDataMap.get((Object)lineSplit[0]).value) continue;
                    String newLineContent = String.valueOf(lineSplit[0]) + ": " + this.configDataMap.get((Object)lineSplit[0]).value;
                    ChangeLineInFile changeFile = new ChangeLineInFile();
                    changeFile.changeALineInATextFile(sFile, newLineContent, lineNumber);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

