/*
 * Decompiled with CFR 0.152.
 */
package com.skunity.plugin.utils;

import com.skunity.plugin.Logger;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;

public class HttpDownloadUtility {
    private static final int BUFFER_SIZE = 4096;

    public static File downloadFile(String fileURL, String saveDir) throws IOException {
        URL url = new URL(fileURL);
        HttpURLConnection httpConn = (HttpURLConnection)url.openConnection();
        httpConn.setRequestProperty("User-Agent", "The official skUnity Plugin");
        int responseCode = httpConn.getResponseCode();
        String saveFilePath = null;
        if (responseCode == 200) {
            String fileName = "";
            String disposition = httpConn.getHeaderField("Content-Disposition");
            String contentType = httpConn.getContentType();
            int contentLength = httpConn.getContentLength();
            if (disposition != null) {
                int index = disposition.indexOf("filename=");
                if (index > 0) {
                    String[] fileNameArray = disposition.split("filename=");
                    fileName = fileNameArray[1].substring(0, fileNameArray[1].length() - 1);
                }
            } else {
                fileName = fileURL.substring(fileURL.lastIndexOf("/") + 1, fileURL.length());
            }
            Logger.debug("Content-Type = " + contentType);
            Logger.debug("Content-Disposition = " + disposition);
            Logger.debug("Content-Length = " + contentLength);
            Logger.debug("fileName = " + fileName);
            InputStream inputStream = httpConn.getInputStream();
            saveFilePath = String.valueOf(saveDir) + File.separator + fileName;
            FileOutputStream outputStream = new FileOutputStream(saveFilePath);
            int bytesRead = -1;
            byte[] buffer = new byte[4096];
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, bytesRead);
            }
            outputStream.close();
            inputStream.close();
        }
        httpConn.disconnect();
        if (saveFilePath == null) {
            return null;
        }
        return new File(saveFilePath);
    }
}

