/*
 * Decompiled with CFR 0.152.
 */
package com.skunity.plugin.utils;

import com.skunity.plugin.Logger;
import com.skunity.plugin.SkunityCommand;
import com.skunity.plugin.utils.PlayerChat;
import com.skunity.plugin.utils.SKUSubCommand;
import com.skunity.plugin.utils.SKUSubCommandInfo;
import java.lang.reflect.Field;
import java.util.HashMap;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandMap;
import org.bukkit.command.CommandSender;

public class CommandRegistry {
    private Field bukkitCommandMap;
    private CommandMap commandMap;
    private HashMap<String, SKUSubCommand> subCommands = new HashMap();
    private HashMap<SKUSubCommand, SKUSubCommandInfo> subCommandsInfo = new HashMap();

    public CommandRegistry() {
        try {
            this.bukkitCommandMap = Bukkit.getServer().getClass().getDeclaredField("commandMap");
            this.bukkitCommandMap.setAccessible(true);
            this.commandMap = (CommandMap)this.bukkitCommandMap.get(Bukkit.getServer());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void register(String name, Command commandClass) {
        this.commandMap.register(name, commandClass);
    }

    public void registerSubCommand(SKUSubCommand commandClass) {
        SKUSubCommandInfo info = this.subCommandsInfo.get(commandClass);
        Logger.debug("A command has been registered: " + info.command);
        this.subCommands.put(info.command, commandClass);
        String[] stringArray = info.aliases;
        int n = info.aliases.length;
        int n2 = 0;
        while (n2 < n) {
            String a = stringArray[n2];
            if (a != "" || a != " ") {
                this.subCommands.put(a, commandClass);
            }
            ++n2;
        }
    }

    public Boolean subCommandExists(String command) {
        return this.subCommands.containsKey(command);
    }

    public HashMap<String, SKUSubCommand> getSubCommands() {
        return this.subCommands;
    }

    public void setInfo(SKUSubCommand sub, SKUSubCommandInfo info) {
        this.subCommandsInfo.put(sub, info);
    }

    public HashMap<SKUSubCommand, SKUSubCommandInfo> getInfo() {
        return this.subCommandsInfo;
    }

    public void execute(String command, SkunityCommand skUnity, CommandSender sender, String alias, String[] args) {
        if (this.subCommandExists(command).booleanValue()) {
            SKUSubCommand cmd = this.subCommands.get(command);
            SKUSubCommandInfo cmdInfo = this.subCommandsInfo.get(cmd);
            if (cmdInfo.permission == null || sender.hasPermission(cmdInfo.permission)) {
                this.subCommands.get(command).execute(skUnity, sender, alias, args);
            } else {
                new PlayerChat(sender).severe("You do not have permission to access that sub-command");
            }
        } else {
            Logger.severe("There was an attempt to run the command " + command + ", but it doesn't exist!");
        }
    }
}

