/*
 * Decompiled with CFR 0.152.
 */
package com.skunity.plugin.skript;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.skunity.plugin.Config;
import com.skunity.plugin.Logger;
import com.skunity.plugin.files.SKUResourceData;
import com.skunity.plugin.utils.CoreUtil;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.event.Event;

public class ExprDownloadResource
extends SimpleExpression<Boolean> {
    private Expression<Integer> integerID;
    private Expression<Integer> version;
    private Boolean useLocalVersion = false;

    static {
        Skript.registerExpression(ExprDownloadResource.class, Boolean.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"[(skunity|sku)] (download|get) resource with [id] %integer% [[at] version %integer%]"});
    }

    protected Boolean[] get(Event event) {
        String resourceid = String.valueOf(this.integerID.getSingle(event));
        SKUResourceData json = CoreUtil.getResourceData(resourceid);
        if (json == null) {
            Logger.skriptError("Attempted to get resource data for " + resourceid + ", but it doesn't exist");
            return new Boolean[]{false};
        }
        String downloadURL = this.useLocalVersion != false ? String.format("https://forums.skunity.com/resources/%s/download?version=%s", json.resource_id, this.version.getSingle(event)) : String.format("https://forums.skunity.com/resources/%s/download?version=%s", json.resource_id, json.latest_version);
        String path = "";
        path = json.filename.endsWith(".sk") ? "./plugins/Skript/scripts/" : "./plugins/";
        Boolean gotIt = CoreUtil.justDownloadFile(downloadURL, path);
        if (gotIt.booleanValue()) {
            if (json.filename.endsWith(".sk") && Config.AUTO_RUN_SCRIPTS) {
                Bukkit.getServer().dispatchCommand((CommandSender)Bukkit.getConsoleSender(), "sk reload " + json.filename);
            }
        } else {
            Logger.skriptError("Failed to download resource " + resourceid + ", from " + downloadURL + ", to " + path);
        }
        return new Boolean[]{gotIt};
    }

    public String toString(@Nullable Event event, boolean b) {
        return new String[]{"[(skunity|sku)] (download|get) resource with [id] %string%"}.toString();
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        this.integerID = exprs[0];
        if (Integer.valueOf(exprs[1].toString()) > 1) {
            this.version = exprs[1];
            this.useLocalVersion = true;
        }
        return true;
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends Boolean> getReturnType() {
        return Boolean.class;
    }
}

