/*
 * Decompiled with CFR 0.152.
 */
package com.skunity.plugin.files;

import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.util.HashMap;

public class SKUResourceData {
    public String hash;
    public String result;
    public String version_string;
    public String title;
    public String author;
    public String filename;
    public Integer resource_id;
    public Integer this_version;
    public Integer latest_version;
    public Integer author_id;
    public Boolean is_latest;
    public HashMap<String, Object> dynValues = new HashMap();
    public JsonObject jsonData;
    public String download_url;

    public SKUResourceData(JsonObject data) {
        this.jsonData = data;
        this.setValue("hash", "String");
        this.setValue("result", "String");
        this.setValue("version_string", "String");
        this.setValue("title", "String");
        this.setValue("author", "String");
        this.setValue("filename", "String");
        this.setValue("resource_id", "Integer");
        this.setValue("this_version", "Integer");
        this.setValue("latest_version", "Integer");
        this.setValue("author_id", "Integer");
        this.setValue("is_latest", "Boolean");
        this.download_url = MessageFormat.format("https://forums.skunity.com/resources/{0}/download?version={1}", this.resource_id, this.latest_version);
    }

    public Object get(String key) {
        return this.dynValues.get(key);
    }

    public String getString(String key) {
        return (String)this.dynValues.get(key);
    }

    public Integer getInteger(String key) {
        return (Integer)this.dynValues.get(key);
    }

    public Boolean getBoolean(String key) {
        return (Boolean)this.dynValues.get(key);
    }

    public void setValue(String key) {
        if (this.jsonData.has(key)) {
            JsonPrimitive o = this.jsonData.get(key).getAsJsonPrimitive();
            if (o.isString()) {
                this.setValue(key, "String");
            } else if (o.isNumber()) {
                this.setValue(key, "Integer");
            } else if (o.isBoolean()) {
                this.setValue(key, "Boolean");
            } else {
                System.out.println("Unknown instanceof for " + key + ". Real type: " + o.getClass().getCanonicalName());
            }
        } else {
            System.out.print("Attempted to get " + key + " but is not set");
        }
    }

    public void setValue(String key, String type) {
        Object value;
        block8: {
            value = null;
            try {
                if (type == "String") {
                    value = this.jsonData.get(key).getAsString();
                    break block8;
                }
                if (type == "Integer") {
                    value = Integer.valueOf(this.jsonData.get(key).getAsString());
                    break block8;
                }
                if (type == "Boolean") {
                    value = Boolean.valueOf(this.jsonData.get(key).getAsString());
                    break block8;
                }
                System.out.println("Invalid type given for " + key);
                return;
            }
            catch (Exception e) {
                return;
            }
        }
        if (value == null) {
            System.out.println("Null value for " + key);
            return;
        }
        this.dynValues.put(key, value);
        try {
            SKUResourceData test = this;
            Class<?> c = test.getClass();
            Field field = c.getField(key);
            field.setAccessible(true);
            field.set(this, value);
            System.out.print("Set " + key + " to " + value);
            return;
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            System.out.println("An exception happened for (2) " + key);
            e.printStackTrace();
            return;
        }
    }
}

