/*
 * Decompiled with CFR 0.152.
 */
package net.rayfall.eyesniper2.skRayFall.effectlib.effect;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import net.rayfall.eyesniper2.skRayFall.effectlib.Effect;
import net.rayfall.eyesniper2.skRayFall.effectlib.EffectManager;
import net.rayfall.eyesniper2.skRayFall.effectlib.EffectType;
import net.rayfall.eyesniper2.skRayFall.effectlib.util.ParticleEffect;
import net.rayfall.eyesniper2.skRayFall.effectlib.util.VectorUtils;
import org.bukkit.Location;
import org.bukkit.util.Vector;

public class ImageEffect
extends Effect {
    public ParticleEffect particle = ParticleEffect.FLAME;
    public String fileName = null;
    public boolean invert = false;
    public int stepX = 10;
    public int stepY = 10;
    public float size = 0.025f;
    public boolean enableRotation = true;
    public Plane plane = Plane.XYZ;
    public double angularVelocityX = 0.015707963267948967;
    public double angularVelocityY = 0.018479956785822312;
    public double angularVelocityZ = 0.02026833970057931;
    protected BufferedImage image = null;
    protected boolean isGif = false;
    protected File gifFile = null;
    protected int step = 0;

    public ImageEffect(EffectManager effectManager) throws IOException {
        super(effectManager);
        this.type = EffectType.REPEATING;
        this.period = 10;
        this.iterations = 60;
    }

    public void loadFile(File file) {
        try {
            this.image = ImageIO.read(file);
            this.isGif = file.getName().endsWith(".gif");
            this.gifFile = file;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.image = null;
        }
    }

    @Override
    public void onRun() {
        if (this.image == null && this.fileName != null) {
            this.loadFile(new File(this.fileName));
        }
        if (this.image == null) {
            this.cancel();
            return;
        }
        if (this.isGif) {
            try {
                this.image = this.getImg(this.step);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ++this.step;
        }
        Location location = this.getLocation();
        for (int y = 0; y < this.image.getHeight(); y += this.stepY) {
            for (int x = 0; x < this.image.getWidth(); x += this.stepX) {
                int clr = this.image.getRGB(x, y);
                if (!this.invert && Color.black.getRGB() != clr || this.invert && Color.black.getRGB() == clr) continue;
                Vector v = new Vector((float)this.image.getWidth() / 2.0f - (float)x, (float)this.image.getHeight() / 2.0f - (float)y, 0.0f).multiply(this.size);
                VectorUtils.rotateAroundAxisY(v, -location.getYaw() * ((float)Math.PI / 180));
                this.display(this.particle, location.add(v));
                location.subtract(v);
            }
        }
    }

    private BufferedImage getImg(int s) throws IOException {
        ArrayList<BufferedImage> images = new ArrayList<BufferedImage>();
        ImageReader reader = ImageIO.getImageReadersBySuffix("GIF").next();
        ImageInputStream in = ImageIO.createImageInputStream(this.gifFile);
        reader.setInput(in);
        int count = reader.getNumImages(true);
        for (int i = 0; i < count; ++i) {
            BufferedImage image = reader.read(i);
            images.add(image);
        }
        if (this.step >= reader.getNumImages(true)) {
            this.step = 0;
            return (BufferedImage)images.get(s - 1);
        }
        return (BufferedImage)images.get(s);
    }

    public static enum Plane {
        X,
        Y,
        Z,
        XY,
        XZ,
        XYZ,
        YZ;

    }
}

