/*
 * Decompiled with CFR 0.152.
 */
package net.rayfall.eyesniper2.skrayfall.voting;

import ch.njol.skript.Skript;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.vexsoftware.votifier.model.VotifierEvent;
import java.util.Collection;
import net.rayfall.eyesniper2.skrayfall.Core;
import net.rayfall.eyesniper2.skrayfall.voting.OfflineVote;
import net.rayfall.eyesniper2.skrayfall.voting.RayFallOfflineVoteEvent;
import net.rayfall.eyesniper2.skrayfall.voting.RayFallVoteEvent;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;

public class RayFallVoteListener
implements Listener {
    private static Multimap<String, OfflineVote> voteMap = HashMultimap.create();

    public RayFallVoteListener(Core core) {
        core.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)core);
    }

    @EventHandler
    public void onVote(VotifierEvent votifierEvent) {
        String name = votifierEvent.getVote().getUsername();
        if (Bukkit.getPlayer((String)name) != null && Bukkit.getPlayer((String)name).isOnline()) {
            RayFallVoteEvent event = new RayFallVoteEvent(Bukkit.getPlayer((String)name), votifierEvent.getVote().getServiceName());
            Bukkit.getPluginManager().callEvent((Event)event);
        } else {
            voteMap.put((Object)name, (Object)new OfflineVote(votifierEvent.getVote().getServiceName(), votifierEvent.getVote().getTimeStamp()));
            if (Bukkit.getPlayer((String)name) != null && !Bukkit.getPlayer((String)name).isOnline()) {
                RayFallOfflineVoteEvent offlineEvent = new RayFallOfflineVoteEvent(Bukkit.getPlayer((String)name), votifierEvent.getVote().getServiceName());
                Bukkit.getPluginManager().callEvent((Event)offlineEvent);
            }
            Skript.error((String)"Player is not online, saving vote for the next time they are online");
        }
    }

    @EventHandler
    public void triggerVoteOnJoin(PlayerJoinEvent evt) {
        Player player = evt.getPlayer();
        if (voteMap.containsKey((Object)player.getName())) {
            Collection listOfVotes = voteMap.get((Object)player.getName());
            for (OfflineVote vote : listOfVotes) {
                RayFallVoteEvent event = new RayFallVoteEvent(player, vote.getSite());
                Bukkit.getPluginManager().callEvent((Event)event);
            }
            voteMap.removeAll((Object)player.getName());
        }
    }
}

