/*
 * Decompiled with CFR 0.152.
 */
package net.rayfall.eyesniper2.skRayFall.effectlib.entity;

import java.util.HashMap;
import java.util.Map;
import net.rayfall.eyesniper2.skRayFall.effectlib.EffectLib;
import net.rayfall.eyesniper2.skRayFall.effectlib.util.RandomUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Item;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public final class EntityManager {
    private final EffectLib effectLib;
    private final Map<Entity, BukkitTask> entities;
    private boolean disposed = false;

    public EntityManager(EffectLib effectLib) {
        this.effectLib = effectLib;
        this.entities = new HashMap<Entity, BukkitTask>();
    }

    public void removeAll() {
        for (Map.Entry<Entity, BukkitTask> entry : this.entities.entrySet()) {
            entry.getKey().remove();
            entry.getValue().cancel();
        }
        this.entities.clear();
    }

    public void remove(Entity entity) {
        this.entities.get(entity).cancel();
        this.entities.remove(entity);
        entity.remove();
    }

    public void add(final Entity entity, int duration) {
        if (this.disposed) {
            throw new IllegalStateException("EffectManager is disposed and not able to accept any effects.");
        }
        BukkitTask task = Bukkit.getScheduler().runTaskLater((Plugin)this.effectLib, new Runnable(){

            @Override
            public void run() {
                EntityManager.this.remove(entity);
            }
        }, (long)duration);
        this.entities.put(entity, task);
    }

    public Item spawnItem(ItemStack is, Location loc, int duration) {
        ItemMeta im = is.getItemMeta();
        im.setDisplayName("EffectItem" + ChatColor.RED + RandomUtils.random.nextInt(10000));
        is.setItemMeta(im);
        Item i = loc.getWorld().dropItem(loc, is);
        i.setMetadata("EffectItem", (MetadataValue)new FixedMetadataValue((Plugin)EffectLib.instance(), (Object)0));
        this.add((Entity)i, duration);
        return i;
    }

    public Entity spawnEntity(EntityType type, Location loc, int duration) {
        Entity e = loc.getWorld().spawnEntity(loc, type);
        e.setMetadata("EffectItem", (MetadataValue)new FixedMetadataValue((Plugin)EffectLib.instance(), (Object)0));
        this.add(e, duration);
        return e;
    }

    public void dispose() {
        this.disposed = true;
        this.removeAll();
    }
}

