/*
 * Decompiled with CFR 0.152.
 */
package net.rayfall.eyesniper2.skRayFall.effectlib.effect;

import net.rayfall.eyesniper2.skRayFall.effectlib.Effect;
import net.rayfall.eyesniper2.skRayFall.effectlib.EffectManager;
import net.rayfall.eyesniper2.skRayFall.effectlib.EffectType;
import net.rayfall.eyesniper2.skRayFall.effectlib.math.EquationTransform;
import net.rayfall.eyesniper2.skRayFall.effectlib.util.ParticleEffect;
import net.rayfall.eyesniper2.skRayFall.effectlib.util.VectorUtils;
import org.bukkit.Location;
import org.bukkit.util.Vector;

public class EquationEffect
extends Effect {
    public ParticleEffect particle = ParticleEffect.REDSTONE;
    public String xEquation = "t";
    public String yEquation = "0";
    public String zEquation = "0";
    public String variable = "t";
    public int particles = 1;
    public String x2Equation = null;
    public String y2Equation = null;
    public String z2Equation = null;
    public String variable2 = "t2";
    public int particles2 = 0;
    public boolean orient = true;
    public boolean cycle = false;
    private EquationTransform xTransform;
    private EquationTransform yTransform;
    private EquationTransform zTransform;
    private EquationTransform x2Transform;
    private EquationTransform y2Transform;
    private EquationTransform z2Transform;
    private int step;

    public EquationEffect(EffectManager effectManager) {
        super(effectManager);
        this.type = EffectType.REPEATING;
        this.period = 1;
        this.iterations = 100;
        this.step = 0;
    }

    @Override
    public void onRun() {
        if (this.xTransform == null) {
            this.xTransform = new EquationTransform(this.xEquation, this.variable, "p", "p2");
            this.yTransform = new EquationTransform(this.yEquation, this.variable, "p", "p2");
            this.zTransform = new EquationTransform(this.zEquation, this.variable, "p", "p2");
            if (this.x2Equation != null && this.y2Equation != null && this.z2Equation != null && this.particles2 > 0) {
                this.x2Transform = new EquationTransform(this.x2Equation, this.variable, this.variable2, "p", "p2");
                this.y2Transform = new EquationTransform(this.y2Equation, this.variable, this.variable2, "p", "p2");
                this.z2Transform = new EquationTransform(this.z2Equation, this.variable, this.variable2, "p", "p2");
            }
        }
        Location location = this.getLocation();
        boolean hasInnerEquation = this.x2Transform != null && this.y2Transform != null && this.z2Transform != null;
        for (int i = 0; i < this.particles; ++i) {
            Double xValue = this.xTransform.get(this.step, this.particles);
            Double yValue = this.yTransform.get(this.step, this.particles);
            Double zValue = this.zTransform.get(this.step, this.particles);
            Vector result = new Vector(xValue.doubleValue(), yValue.doubleValue(), zValue.doubleValue());
            if (this.orient) {
                result = VectorUtils.rotateVector(result, location);
            }
            Location targetLocation = location.clone();
            targetLocation.add(result);
            if (!hasInnerEquation) {
                this.display(this.particle, targetLocation);
            } else {
                for (int j = 0; j < this.particles2; ++j) {
                    Double x2Value = this.x2Transform.get(this.step, j, this.particles, this.particles2);
                    Double y2Value = this.y2Transform.get(this.step, j, this.particles, this.particles2);
                    Double z2Value = this.z2Transform.get(this.step, j, this.particles, this.particles2);
                    Location target2Location = targetLocation.clone();
                    target2Location.setX(target2Location.getX() + x2Value);
                    target2Location.setY(target2Location.getY() + y2Value);
                    target2Location.setZ(target2Location.getZ() + z2Value);
                    this.display(this.particle, target2Location);
                }
            }
            ++this.step;
        }
        if (this.cycle) {
            this.step = 0;
        }
    }
}

