/*
 * Decompiled with CFR 0.152.
 */
package net.rayfall.eyesniper2.skRayFall.Scoreboard;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import net.rayfall.eyesniper2.skRayFall.Scoreboard.GroupScore;
import net.rayfall.eyesniper2.skRayFall.Scoreboard.SingleScore;
import net.rayfall.eyesniper2.skRayFall.skRayFall;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Score;

public class IDScoreBoardManager
implements Listener {
    private HashMap<String, SingleScore> singleScoreMap = new HashMap();
    private HashMap<String, ArrayList<Player>> groupMap = new HashMap();
    private HashMap<String, GroupScore> groupScoreMap = new HashMap();

    public IDScoreBoardManager(skRayFall core) {
        core.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)core);
    }

    public void dumpData() {
        this.singleScoreMap.clear();
        this.groupMap.clear();
        this.groupScoreMap.clear();
    }

    public void setScoreID(String id, Score score, Player player) {
        this.singleScoreMap.put(id, new SingleScore(score, player));
    }

    public void adjustGroupIDScore(String id, String text, int value) {
        this.groupScoreMap.put(id, new GroupScore(text, value));
        this.groupMap.put(id, new ArrayList());
    }

    public void addPlayerToGroupID(String id, Player p) {
        if (this.groupScoreMap.containsKey(id) && p != null) {
            this.groupMap.get(id).add(p);
            GroupScore s = this.groupScoreMap.get(id);
            Score newScore = p.getScoreboard().getObjective(DisplaySlot.SIDEBAR).getScore(s.getName());
            newScore.setScore(s.getValue());
        }
    }

    public void removePlayerFromGroupScore(String id, Player p) {
        if (this.groupScoreMap.containsKey(id) && this.groupMap.get(id).contains(p)) {
            GroupScore s = this.groupScoreMap.get(id);
            p.getScoreboard().resetScores(s.getName());
            this.groupMap.get(id).remove(p);
        }
    }

    public void groupUpdateScore(String id, String newName, int newValue) {
        if (this.groupScoreMap.containsKey(id) && this.groupMap.get(id) != null) {
            ArrayList<Player> ls = this.groupMap.get(id);
            GroupScore old = this.groupScoreMap.get(id);
            for (Player p : ls) {
                Objective obj = p.getScoreboard().getObjective(DisplaySlot.SIDEBAR);
                obj.getScoreboard().resetScores(old.getName());
                Score newScore = obj.getScore(newName);
                newScore.setScore(newValue);
            }
            this.groupScoreMap.put(id, new GroupScore(newName, newValue));
        }
    }

    public void updateSingleScore(String id, String newName, int newValue) {
        if (this.singleScoreMap.containsKey(id)) {
            SingleScore old = this.singleScoreMap.get(id);
            Player p = old.getPlayer();
            Objective obj = p.getScoreboard().getObjective(DisplaySlot.SIDEBAR);
            Score newScore = obj.getScore(newName);
            obj.getScoreboard().resetScores(old.getScore().getEntry());
            newScore.setScore(newValue);
            this.singleScoreMap.put(id, new SingleScore(newScore, p));
        }
    }

    public boolean isIdSet(String id) {
        return this.singleScoreMap.containsKey(id);
    }

    public Score getScore(String id) {
        if (this.singleScoreMap.containsKey(id)) {
            return this.singleScoreMap.get(id).getScore();
        }
        return null;
    }

    public void deleteScoreID(String s) {
        this.singleScoreMap.remove(s);
    }

    public void removeSingleScoresFromPlayer(Player p) {
        Iterator<String> i = this.singleScoreMap.keySet().iterator();
        while (i.hasNext()) {
            String id = i.next();
            if (this.singleScoreMap.get(id).getPlayer() != p) continue;
            i.remove();
        }
    }

    public void removeGroupScoresFromPlayer(Player p) {
        for (String id : this.groupMap.keySet()) {
            if (!this.groupMap.get(id).contains(p)) continue;
            this.groupMap.get(id).remove(p);
        }
    }

    public void deleteGroupScore(String id) {
        if (this.groupScoreMap.containsKey(id)) {
            ArrayList<Player> ls = this.groupMap.get(id);
            GroupScore old = this.groupScoreMap.get(id);
            for (Player p : ls) {
                p.getScoreboard().resetScores(old.getName());
            }
        }
    }

    public String getNameOfSingleScore(String id) {
        SingleScore s = this.singleScoreMap.get(id);
        if (s != null) {
            return s.getScore().getEntry();
        }
        return null;
    }

    public int getValueOfSingleScore(String id) {
        SingleScore s = this.singleScoreMap.get(id);
        if (s != null) {
            return s.getScore().getScore();
        }
        return 0;
    }

    public String getNameOfGroupScore(String id) {
        GroupScore s = this.groupScoreMap.get(id);
        if (s != null) {
            return s.getName();
        }
        return null;
    }

    public int getValueOfGroupScore(String id) {
        GroupScore s = this.groupScoreMap.get(id);
        if (s != null) {
            return s.getValue();
        }
        return 0;
    }

    @EventHandler
    public void AutoRemovePlayersScores(PlayerQuitEvent evt) {
        this.removeSingleScoresFromPlayer(evt.getPlayer());
        this.removeGroupScoresFromPlayer(evt.getPlayer());
    }
}

